/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import jakarta.json.JsonObject;
import java.net.URL;
import java.util.Set;

public class OpenIdProviderMetadata {
    private JsonObject document;
    private final String issuerURI;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String userinfoEndpoint;
    private String endSessionEndpoint;
    private URL jwksURL;
    private final Set<String> scopesSupported;
    private final Set<String> claimsSupported;
    private final Set<String> responseTypesSupported;
    private final Set<String> idTokenSigningAlgValuesSupported;
    private final Set<String> idTokenEncryptionAlgValuesSupported;
    private final Set<String> idTokenEncryptionEncValuesSupported;
    private final Set<String> subjectTypesSupported;
    private String accessTokenIssuerURI;

    public OpenIdProviderMetadata(JsonObject providerDocument, String issuerURI, Set<String> scopesSupported, Set<String> claimsSupported, Set<String> responseTypesSupported, Set<String> idTokenSigningAlgValuesSupported, Set<String> idTokenEncryptionAlgValuesSupported, Set<String> idTokenEncryptionEncValuesSupported, Set<String> subjectTypesSupported) {
        this.document = providerDocument;
        this.issuerURI = issuerURI;
        this.scopesSupported = scopesSupported;
        this.claimsSupported = claimsSupported;
        this.responseTypesSupported = responseTypesSupported;
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
        this.idTokenEncryptionAlgValuesSupported = idTokenEncryptionAlgValuesSupported;
        this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
        this.subjectTypesSupported = subjectTypesSupported;
    }

    public String getIssuerURI() {
        return this.issuerURI;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public OpenIdProviderMetadata setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public OpenIdProviderMetadata setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public OpenIdProviderMetadata setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
        return this;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public OpenIdProviderMetadata setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
        return this;
    }

    public URL getJwksURL() {
        return this.jwksURL;
    }

    public OpenIdProviderMetadata setJwksURL(URL jwksURL) {
        this.jwksURL = jwksURL;
        return this;
    }

    public JsonObject getDocument() {
        return this.document;
    }

    public OpenIdProviderMetadata setDocument(JsonObject document) {
        this.document = document;
        return this;
    }

    public Set<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public Set<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    public Set<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    public Set<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public Set<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    public Set<String> getIdTokenEncryptionAlgValuesSupported() {
        return this.idTokenEncryptionAlgValuesSupported;
    }

    public Set<String> getIdTokenEncryptionEncValuesSupported() {
        return this.idTokenEncryptionEncValuesSupported;
    }

    public String getAccessTokenIssuerURI() {
        if (this.accessTokenIssuerURI == null) {
            return this.issuerURI;
        }
        return this.accessTokenIssuerURI;
    }

    public OpenIdProviderMetadata setAccessTokenIssuerURI(String accessTokenIssuerURI) {
        this.accessTokenIssuerURI = accessTokenIssuerURI != null && !accessTokenIssuerURI.isEmpty() ? accessTokenIssuerURI : null;
        return this;
    }

    public String toString() {
        return OpenIdProviderMetadata.class.getSimpleName() + "{issuerURI=" + this.issuerURI + ", authorizationEndpoint=" + this.authorizationEndpoint + ", tokenEndpoint=" + this.tokenEndpoint + ", userinfoEndpoint=" + this.userinfoEndpoint + ", jwksURI=" + this.jwksURL + ", accessTokenIssuerURI=" + this.accessTokenIssuerURI + "}";
    }
}

