/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.shaded.nimbusds.jose.EncryptionMethod;
import fish.payara.security.shaded.nimbusds.jose.JWEAlgorithm;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWKSet;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.ImmutableJWKSet;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSource;
import java.text.ParseException;

public class OpenIdTokenEncryptionMetadata {
    private JWEAlgorithm encryptionAlgorithm;
    private EncryptionMethod encryptionMethod;
    private JWKSource privateKeySource;

    public JWEAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public OpenIdTokenEncryptionMetadata setEncryptionAlgorithm(JWEAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public OpenIdTokenEncryptionMetadata setEncryptionAlgorithm(String encryptionAlgorithm) {
        if (!OpenIdUtil.isEmpty(encryptionAlgorithm)) {
            this.encryptionAlgorithm = JWEAlgorithm.parse(encryptionAlgorithm);
        }
        return this;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public OpenIdTokenEncryptionMetadata setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
        return this;
    }

    public OpenIdTokenEncryptionMetadata setEncryptionMethod(String encryptionMethod) {
        if (!OpenIdUtil.isEmpty(encryptionMethod)) {
            this.encryptionMethod = EncryptionMethod.parse(encryptionMethod);
        }
        return this;
    }

    public JWKSource getPrivateKeySource() {
        return this.privateKeySource;
    }

    public OpenIdTokenEncryptionMetadata setPrivateKeySource(JWKSource privateKeySource) {
        this.privateKeySource = privateKeySource;
        return this;
    }

    public OpenIdTokenEncryptionMetadata setPrivateKeySource(String jwks) {
        if (!OpenIdUtil.isEmpty(jwks)) {
            try {
                this.privateKeySource = new ImmutableJWKSet(JWKSet.parse(jwks));
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this;
    }

    public String toString() {
        return OpenIdTokenEncryptionMetadata.class.getSimpleName() + "{encryptionAlgorithm=" + this.encryptionAlgorithm + ", encryptionMethod=" + this.encryptionMethod + "}";
    }
}

