/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.jwk.source;

import fish.payara.security.shaded.jcip.annotations.ThreadSafe;
import fish.payara.security.shaded.nimbusds.jose.KeySourceException;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWK;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWKSelector;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWKSet;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSetSource;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSource;
import fish.payara.security.shaded.nimbusds.jose.proc.SecurityContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ThreadSafe
public class JWKSetBasedJWKSource<C extends SecurityContext>
implements JWKSource<C>,
Closeable {
    private final JWKSetSource<C> source;

    public JWKSetBasedJWKSource(JWKSetSource<C> source) {
        Objects.requireNonNull(source);
        this.source = source;
    }

    @Override
    public List<JWK> get(JWKSelector jwkSelector, C context) throws KeySourceException {
        long currentTime = System.currentTimeMillis();
        JWKSet jwkSet = this.source.getJWKSet(JWKSetCacheRefreshEvaluator.noRefresh(), currentTime, context);
        List<JWK> select = jwkSelector.select(jwkSet);
        if (select.isEmpty()) {
            JWKSet recentJwkSet = this.source.getJWKSet(JWKSetCacheRefreshEvaluator.referenceComparison(jwkSet), currentTime, context);
            select = jwkSelector.select(recentJwkSet);
        }
        return select;
    }

    public JWKSetSource<C> getJWKSetSource() {
        return this.source;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

