/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.shaded.nimbusds.jose.jwk.source;

import fish.payara.security.shaded.jcip.annotations.ThreadSafe;
import fish.payara.security.shaded.nimbusds.jose.KeySourceException;
import fish.payara.security.shaded.nimbusds.jose.jwk.JWKSet;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSetParseException;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSetRetrievalException;
import fish.payara.security.shaded.nimbusds.jose.jwk.source.JWKSetSource;
import fish.payara.security.shaded.nimbusds.jose.proc.SecurityContext;
import fish.payara.security.shaded.nimbusds.jose.util.Resource;
import fish.payara.security.shaded.nimbusds.jose.util.ResourceRetriever;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

@ThreadSafe
public class URLBasedJWKSetSource<C extends SecurityContext>
implements JWKSetSource<C> {
    private final URL url;
    private final ResourceRetriever resourceRetriever;

    public URLBasedJWKSetSource(URL url, ResourceRetriever resourceRetriever) {
        Objects.requireNonNull(url, "The URL must not be null");
        this.url = url;
        Objects.requireNonNull(resourceRetriever, "The resource retriever must not be null");
        this.resourceRetriever = resourceRetriever;
    }

    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator refreshEvaluator, long currentTime, C context) throws KeySourceException {
        Resource resource;
        try {
            resource = this.resourceRetriever.retrieveResource(this.url);
        }
        catch (IOException e) {
            throw new JWKSetRetrievalException("Couldn't retrieve JWK set from URL: " + e.getMessage(), e);
        }
        try {
            return JWKSet.parse(resource.getContent());
        }
        catch (Exception e) {
            throw new JWKSetParseException("Unable to parse JWK set", e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

