/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployapi;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.glassfish.deployapi.SunDeploymentManager;
import org.glassfish.deployment.client.AbstractDeploymentFacility;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.glassfish.logging.annotation.LogMessageInfo;

public class SunDeploymentFactory
implements DeploymentFactory {
    private static LocalStringManagerImpl xlocalStrings = new LocalStringManagerImpl(SunDeploymentFactory.class);
    private static final String PE_BETA_URISTRING = "deployer:Sun:S1AS::";
    private static final String DEFAULT_URISTRING = "deployer:Sun:AppServer::";
    private static final String HTTPS = "https";
    private static final String URI_SEPARATOR = ":";
    private static final String LOCAL_HOST = "localhost";
    private static final int HOST_PORT = 4848;
    private static final String[] supportedURIs = new String[]{"deployer:Sun:S1AS::", "deployer:Sun:AppServer::"};
    private static final Logger deplLogger = AbstractDeploymentFacility.deplLogger;
    @LogMessageInfo(message="Deployment manager load failure.  Unable to find {0}", cause="A deployment manager is not available.", action="Correct the reference to the deployment manager.", level="SEVERE")
    private static final String NO_DEPLOYMENT_MANAGER = "AS-DEPLOYMENT-04019";

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            return null;
        }
        ServerConnectionIdentifier hostInfo = null;
        try {
            hostInfo = this.parseURIForHostInfo(uri);
        }
        catch (Exception ex) {
            DeploymentManagerCreationException e = new DeploymentManagerCreationException(xlocalStrings.getLocalString("enterprise.deployapi.spi.wronghostidentifier", "Wrong host identifier in uri {0} ", uri));
            e.initCause((Throwable)ex);
            throw e;
        }
        try {
            hostInfo.setUserName(username);
            hostInfo.setPassword(password);
            SunDeploymentManager answer = null;
            answer = new SunDeploymentManager(hostInfo);
            return answer;
        }
        catch (Throwable t) {
            DeploymentManagerCreationException e = new DeploymentManagerCreationException(xlocalStrings.getLocalString("enterprise.deployapi.spi.exceptionwhileconnecting", "Exception while connecting to {0} : {1}", uri, t.getMessage()));
            e.initCause(t);
            throw e;
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) {
        if (this.handlesURI(uri)) {
            return new SunDeploymentManager();
        }
        return null;
    }

    public String getDisplayName() {
        return xlocalStrings.getLocalString("enterprise.deployapi.spi.DisplayName", "Sun Java System Application Server");
    }

    public String getProductVersion() {
        return xlocalStrings.getLocalString("enterprise.deployapi.spi.ProductVersion", "9.0");
    }

    public boolean handlesURI(String uri) {
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.fine("handlesURI: URI [" + uri + "]");
        }
        if (uri != null) {
            try {
                this.parseURIForHostInfo(uri);
                return true;
            }
            catch (Exception ex) {
                deplLogger.log(Level.SEVERE, NO_DEPLOYMENT_MANAGER, uri);
            }
        }
        return false;
    }

    public ServerConnectionIdentifier parseURIForHostInfo(String uri) throws Exception {
        String targetURI = this.toTargetURI(uri);
        if (targetURI == null) {
            throw new Exception(xlocalStrings.getLocalString("enterprise.deployapi.spi.invaliduri", "Invalid URI"));
        }
        ServerConnectionIdentifier sci = new ServerConnectionIdentifier();
        if (uri.length() == targetURI.length()) {
            sci.setHostName(LOCAL_HOST);
            sci.setHostPort(4848);
        } else {
            String reminder = uri.substring(targetURI.length());
            String[] splitted = reminder.split(URI_SEPARATOR);
            if (splitted.length < 2) {
                throw new Exception(xlocalStrings.getLocalString("enterprise.deployapi.spi.invaliduri", "Invalid URI"));
            }
            if ("".equals(splitted[0])) {
                sci.setHostName(LOCAL_HOST);
            } else {
                sci.setHostName(splitted[0]);
            }
            if ("".equals(splitted[1])) {
                sci.setHostPort(4848);
            } else {
                sci.setHostPort(Integer.parseInt(splitted[1]));
            }
            if (splitted.length > 2 && HTTPS.equals(splitted[2])) {
                sci.setSecure(true);
            }
        }
        return sci;
    }

    private String toTargetURI(String uri) {
        if (uri == null) {
            return null;
        }
        for (String supportedURI : supportedURIs) {
            if (uri.indexOf(supportedURI) != 0) continue;
            return supportedURI;
        }
        return null;
    }
}

