/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.client;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.admin.CommandException;
import org.glassfish.deployment.client.AbstractDeploymentFacility;
import org.glassfish.deployment.client.CommandXMLResultParser;
import org.glassfish.deployment.client.DFDeploymentProperties;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.ServerConnectionIdentifier;

public class RemoteDeploymentFacility
extends AbstractDeploymentFacility {
    @Override
    protected boolean doConnect() {
        return true;
    }

    @Override
    public boolean doDisconnect() {
        return true;
    }

    @Override
    protected AbstractDeploymentFacility.DFCommandRunner getDFCommandRunner(String commandName, DFDeploymentProperties commandOptions, String[] operands) throws CommandException {
        return new RemoteCommandRunner(commandName, commandOptions, operands);
    }

    protected String[] prepareRemoteCommandArguments(String commandName, DFDeploymentProperties options, String[] operands) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(commandName);
        if (options == null) {
            options = new DFDeploymentProperties();
        }
        for (Map.Entry<Object, Object> entry : options.entrySet()) {
            result.add("--" + entry.getKey() + "=" + this.convertValue(entry.getValue()));
        }
        if (operands != null) {
            for (String o : operands) {
                result.add(o);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected ProgramOptions prepareRemoteCommandProgramOptions(Environment env) throws CommandException {
        ServerConnectionIdentifier targetDAS = this.getTargetDAS();
        ProgramOptions po = new ProgramOptions(env);
        po.setHost(targetDAS.getHostName());
        po.setPort(targetDAS.getHostPort());
        po.setUser(targetDAS.getUserName());
        po.setSecure(targetDAS.isSecure());
        char[] password = this.getTargetDAS().getPassword() == null ? null : this.getTargetDAS().getPassword().toCharArray();
        po.setPassword(password, ProgramOptions.PasswordLocation.LOCAL_PASSWORD);
        po.setOptionsSet(true);
        return po;
    }

    private Object convertValue(Object value) {
        if (value instanceof Properties) {
            StringBuilder sb = new StringBuilder();
            Properties p = (Properties)value;
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(":");
                }
                sb.append((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            return sb.toString();
        }
        return value;
    }

    private class RemoteCommandRunner
    implements AbstractDeploymentFacility.DFCommandRunner {
        private final String commandName;
        private final DFDeploymentProperties commandOptions;
        private final String[] operands;

        private RemoteCommandRunner(String commandName, DFDeploymentProperties commandOptions, String[] operands) {
            this.commandOptions = commandOptions;
            this.commandName = commandName;
            this.operands = operands;
        }

        @Override
        public DFDeploymentStatus run() throws CommandException {
            DFDeploymentStatus dFDeploymentStatus;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                String[] commandArgs = RemoteDeploymentFacility.this.prepareRemoteCommandArguments(this.commandName, this.commandOptions, this.operands);
                Environment env = new Environment();
                ProgramOptions po = RemoteDeploymentFacility.this.prepareRemoteCommandProgramOptions(env);
                RemoteCommand rc = new RemoteCommand(this.commandName, po, env, "jsr-88/xml", (OutputStream)baos);
                rc.executeAndReturnOutput(commandArgs);
                dFDeploymentStatus = CommandXMLResultParser.parse(baos);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            baos.close();
            return dFDeploymentStatus;
        }
    }
}

