/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.impl.authorization;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.security.services.api.authorization.AzAttributeResolver;
import org.glassfish.security.services.api.authorization.AzResource;
import org.glassfish.security.services.api.authorization.AzSubject;
import org.glassfish.security.services.api.authorization.RoleMappingService;
import org.glassfish.security.services.common.PrivilegedLookup;
import org.glassfish.security.services.common.Secure;
import org.glassfish.security.services.config.SecurityConfiguration;
import org.glassfish.security.services.config.SecurityProvider;
import org.glassfish.security.services.impl.ServiceFactory;
import org.glassfish.security.services.impl.authorization.AzEnvironmentImpl;
import org.glassfish.security.services.impl.authorization.AzResourceImpl;
import org.glassfish.security.services.impl.authorization.AzSubjectImpl;
import org.glassfish.security.services.spi.authorization.RoleMappingProvider;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
@Secure(accessPermissionName="security/service/rolemapper")
public final class RoleMappingServiceImpl
implements RoleMappingService,
PostConstruct {
    private static final Level DEBUG_LEVEL = Level.FINER;
    private static final Logger logger = Logger.getLogger("jakarta.enterprise.security.services", "org.glassfish.security.services.LogMessages");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RoleMappingServiceImpl.class);
    @Inject
    private Domain domain;
    @Inject
    private ServiceLocator serviceLocator;
    private org.glassfish.security.services.config.RoleMappingService config;
    private RoleMappingProvider provider;
    private volatile InitializationState initialized = InitializationState.NOT_INITIALIZED;
    private volatile String reasonInitFailed = localStrings.getLocalString("service.role.not_config", "The Role Mapping Service was not configured properly.");
    private final List<AzAttributeResolver> attributeResolvers = Collections.synchronizedList(new ArrayList());
    @LogMessageInfo(message="Role Mapping Service has successfully initialized.", level="INFO")
    private static final String ROLEMAPSVC_INITIALIZED = "SEC-SVCS-00150";
    @LogMessageInfo(message="Role Mapping Service initialization failed, exception {0}, message {1}", level="WARNING")
    private static final String ROLEMAPSVC_INIT_FAILED = "SEC-SVCS-00151";

    final InitializationState getInitializationState() {
        return this.initialized;
    }

    final String getReasonInitializationFailed() {
        return this.reasonInitFailed;
    }

    final void checkServiceAvailability() {
        if (InitializationState.SUCCESS_INIT != this.getInitializationState()) {
            throw new IllegalStateException(localStrings.getLocalString("service.role.not_avail", "The Role Mapping Service is not available.") + this.getReasonInitializationFailed());
        }
    }

    private boolean isDebug() {
        return logger.isLoggable(DEBUG_LEVEL);
    }

    private AzSubject makeAzSubject(Subject subject) {
        AzSubjectImpl azs = new AzSubjectImpl(subject);
        return azs;
    }

    private AzResource makeAzResource(URI resource) {
        AzResourceImpl azr = new AzResourceImpl(resource);
        return azr;
    }

    @Override
    public void initialize(SecurityConfiguration securityServiceConfiguration) {
        if (InitializationState.NOT_INITIALIZED != this.initialized) {
            return;
        }
        try {
            this.config = (org.glassfish.security.services.config.RoleMappingService)securityServiceConfiguration;
            if (this.config != null) {
                List<SecurityProvider> providersConfig = this.config.getSecurityProviders();
                SecurityProvider roleProviderConfig = null;
                if (providersConfig != null) {
                    roleProviderConfig = providersConfig.get(0);
                }
                if (roleProviderConfig != null) {
                    String providerName = roleProviderConfig.getName();
                    if (this.isDebug()) {
                        logger.log(DEBUG_LEVEL, "Attempting to get Role Mapping Provider \"{0}\".", providerName);
                    }
                    this.provider = AccessController.doPrivileged(new PrivilegedLookup<RoleMappingProvider>(this.serviceLocator, RoleMappingProvider.class, providerName));
                    if (this.provider == null) {
                        throw new IllegalStateException(localStrings.getLocalString("service.role.not_provider", "Role Mapping Provider {0} not found.", new Object[]{providerName}));
                    }
                    this.provider.initialize(roleProviderConfig);
                    this.initialized = InitializationState.SUCCESS_INIT;
                    this.reasonInitFailed = null;
                    logger.log(Level.INFO, ROLEMAPSVC_INITIALIZED);
                }
            }
        }
        catch (Exception e) {
            String eMsg = e.getMessage();
            String eClass = e.getClass().getName();
            this.reasonInitFailed = localStrings.getLocalString("service.role.init_failed", "Role Mapping Service initialization failed, exception {0}, message {1}", new Object[]{eClass, eMsg});
            logger.log(Level.WARNING, ROLEMAPSVC_INIT_FAILED, new Object[]{eClass, eMsg});
            throw new RuntimeException(this.reasonInitFailed, e);
        }
        finally {
            if (InitializationState.SUCCESS_INIT != this.initialized) {
                this.initialized = InitializationState.FAILED_INIT;
            }
        }
    }

    @Override
    public boolean isUserInRole(String appContext, Subject subject, URI resource, String role) {
        if (subject == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.subject_null", "The supplied Subject is null."));
        }
        if (resource == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.resource_null", "The supplied Resource is null."));
        }
        return this.isUserInRole(appContext, this.makeAzSubject(subject), this.makeAzResource(resource), role);
    }

    @Override
    public boolean isUserInRole(String appContext, AzSubject subject, AzResource resource, String role) {
        boolean result = false;
        if (subject == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.subject_null", "The supplied Subject is null."));
        }
        if (resource == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("service.resource_null", "The supplied Resource is null."));
        }
        this.checkServiceAvailability();
        result = this.provider.isUserInRole(appContext, subject, resource, role, new AzEnvironmentImpl(), this.attributeResolvers);
        if (this.isDebug()) {
            logger.log(DEBUG_LEVEL, "Role Mapping Service result {0} for role {1} with resource {2} using subject {3} in context {4}.", new String[]{Boolean.toString(result), role, resource.toString(), subject.toString(), appContext});
        }
        return result;
    }

    @Override
    public RoleMappingService.RoleDeploymentContext findOrCreateDeploymentContext(String appContext) {
        this.checkServiceAvailability();
        return this.provider.findOrCreateDeploymentContext(appContext);
    }

    @Override
    public void postConstruct() {
        org.glassfish.security.services.config.RoleMappingService roleConfiguration = ServiceFactory.getSecurityServiceConfiguration(this.domain, org.glassfish.security.services.config.RoleMappingService.class);
        this.initialize(roleConfiguration);
    }

    static enum InitializationState {
        NOT_INITIALIZED,
        SUCCESS_INIT,
        FAILED_INIT;

    }
}

