/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing;

import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.opentracing.OpenTelemetryService;
import fish.payara.opentracing.OpenTracingService;
import io.opentelemetry.api.trace.Tracer;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.Deployment;

public final class PayaraTracingServices {
    static final Config EMPTY_CONFIG = new Config(){

        public <T> T getValue(String s, Class<T> aClass) {
            throw new NoSuchElementException("Empty config");
        }

        public ConfigValue getConfigValue(String s) {
            throw new NoSuchElementException("Empty Config");
        }

        public <T> Optional<T> getOptionalValue(String s, Class<T> aClass) {
            return Optional.empty();
        }

        public Iterable<String> getPropertyNames() {
            return List.of();
        }

        public Iterable<ConfigSource> getConfigSources() {
            return List.of();
        }

        public <T> Optional<Converter<T>> getConverter(Class<T> aClass) {
            return Optional.empty();
        }

        public <T> T unwrap(Class<T> aClass) {
            return null;
        }
    };
    private final RequestTracingService requestTracingService;
    private final OpenTracingService openTracingService;
    private final Deployment deployment;
    private final OpenTelemetryService openTelemetryService;

    public static Config getConfig() {
        try {
            return ConfigProvider.getConfig();
        }
        catch (IllegalArgumentException ex) {
            return EMPTY_CONFIG;
        }
    }

    public PayaraTracingServices() {
        ServiceLocator baseServiceLocator = Globals.getStaticBaseServiceLocator();
        this.requestTracingService = PayaraTracingServices.getFromServiceHandle(baseServiceLocator, RequestTracingService.class);
        this.openTracingService = PayaraTracingServices.getFromServiceHandle(baseServiceLocator, OpenTracingService.class);
        this.deployment = PayaraTracingServices.getFromServiceHandle(baseServiceLocator, Deployment.class);
        this.openTelemetryService = PayaraTracingServices.getFromServiceHandle(baseServiceLocator, OpenTelemetryService.class);
    }

    public boolean isTracingAvailable() {
        return this.requestTracingService != null && this.openTracingService != null && this.openTelemetryService != null;
    }

    public RequestTracingService getRequestTracingService() {
        if (this.isTracingAvailable()) {
            return this.requestTracingService;
        }
        return null;
    }

    public OpenTelemetryService getOpenTelemetryService() {
        if (this.isTracingAvailable()) {
            return this.openTelemetryService;
        }
        return null;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public Tracer getActiveTracer() {
        if (this.isTracingAvailable()) {
            return this.openTelemetryService.getCurrentTracer();
        }
        return null;
    }

    private static <T> T getFromServiceHandle(ServiceLocator serviceLocator, Class<T> serviceClass) {
        ServiceHandle serviceHandle = serviceLocator.getServiceHandle(serviceClass, new Annotation[0]);
        if (serviceHandle != null && serviceHandle.isActive()) {
            return (T)serviceHandle.getService();
        }
        return null;
    }
}

