/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.telemetry.tracing.jaxrs;

import fish.payara.microprofile.telemetry.tracing.jaxrs.OpenTracingHelper;
import fish.payara.opentracing.OpenTelemetryService;
import fish.payara.opentracing.PropagationHelper;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.MalformedURLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

class OpenTelemetryRequestEventListener
implements RequestEventListener {
    private static final Logger LOG = Logger.getLogger(OpenTelemetryRequestEventListener.class.getName());
    private final ResourceInfo resourceInfo;
    private final OpenTelemetryService openTelemetryService;
    private final OpenTracingHelper openTracingHelper;
    private PropagationHelper helper;

    public OpenTelemetryRequestEventListener(ResourceInfo resourceInfo, OpenTelemetryService openTelemetryService, OpenTracingHelper openTracingHelper) {
        this.resourceInfo = resourceInfo;
        this.openTelemetryService = openTelemetryService;
        this.openTracingHelper = openTracingHelper;
    }

    public void onEvent(RequestEvent requestEvent) {
        LOG.fine(() -> "onEvent(event.type=" + requestEvent.getType() + ", path=" + this.getPath(requestEvent) + ")");
        try {
            Span activeSpan;
            switch (requestEvent.getType()) {
                case START: 
                case MATCHING_START: 
                case LOCATOR_MATCHED: 
                case SUBRESOURCE_LOCATED: 
                case REQUEST_FILTERED: 
                case EXCEPTION_MAPPER_FOUND: 
                case EXCEPTION_MAPPING_FINISHED: {
                    return;
                }
            }
            if (requestEvent.getType() == RequestEvent.Type.REQUEST_MATCHED) {
                ContainerRequest requestContext = requestEvent.getContainerRequest();
                if (!this.openTracingHelper.canTrace(this.resourceInfo, requestContext)) {
                    LOG.finest(() -> "canTrace(...) returned false, nothing to do.");
                    return;
                }
                String operationName = this.openTracingHelper.determineOperationName(this.resourceInfo, (ContainerRequestContext)requestContext);
                this.onIncomingRequest(requestEvent, operationName);
                return;
            }
            Span span = activeSpan = this.helper != null ? this.helper.span() : Span.current();
            if (!activeSpan.isRecording()) {
                LOG.finest(() -> "Could not find any active span, nothing to do.");
                return;
            }
            switch (requestEvent.getType()) {
                case ON_EXCEPTION: {
                    this.onException(requestEvent, activeSpan);
                    break;
                }
                case RESOURCE_METHOD_FINISHED: {
                    if (this.helper == null) break;
                    this.helper.closeContext();
                    break;
                }
                case RESP_FILTERS_FINISHED: {
                    this.onOutgoingResponse(requestEvent, activeSpan);
                    break;
                }
                case FINISHED: {
                    if (this.helper != null) {
                        this.finish(requestEvent);
                        break;
                    }
                    LOG.log(Level.FINE, "Request finished but there was no active span");
                    activeSpan.end();
                }
            }
        }
        catch (RuntimeException e) {
            LOG.log(Level.CONFIG, "Exception thrown by the listener!", e);
            throw e;
        }
    }

    private String getPath(RequestEvent event) {
        return event.getUriInfo() == null ? "<unknown>" : event.getUriInfo().getPath();
    }

    private void onException(RequestEvent event, Span activeSpan) {
        LOG.fine(() -> "onException(event=" + event.getType() + ")");
        activeSpan.setStatus(StatusCode.ERROR, event.getException().getMessage());
        activeSpan.setAttribute("error", true);
        activeSpan.setAttribute(SemanticAttributes.EXCEPTION_TYPE, (Object)Throwable.class.getName());
        activeSpan.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        activeSpan.addEvent("exception", Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_MESSAGE, (Object)event.getException().getMessage()));
        activeSpan.recordException(event.getException());
    }

    private void onOutgoingResponse(RequestEvent event, Span activeSpan) {
        LOG.fine(() -> "onOutgoingRequest(event=" + event.getType() + ")");
        ContainerResponse response = Objects.requireNonNull(event.getContainerResponse(), "response");
        Response.StatusType statusInfo = response.getStatusInfo();
        LOG.fine(() -> "Response context: status code=" + statusInfo.getStatusCode() + ", hasEntity=" + response.hasEntity());
        LOG.finest("Setting the HTTP response status etc. to the active span...");
        activeSpan.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, statusInfo.getStatusCode());
        if (statusInfo.getFamily() == Response.Status.Family.SERVER_ERROR) {
            activeSpan.setAttribute("error", true);
            activeSpan.setStatus(StatusCode.ERROR);
            if (response.hasEntity() && response.getEntity() instanceof Throwable) {
                activeSpan.recordException((Throwable)response.getEntity());
                activeSpan.setAttribute(SemanticAttributes.EXCEPTION_TYPE, (Object)Throwable.class.getName());
                activeSpan.addEvent("exception", Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_MESSAGE, (Object)event.getException().getMessage()));
                activeSpan.setStatus(StatusCode.ERROR, event.getException().getMessage());
            }
        }
    }

    private void finish(RequestEvent event) {
        LOG.fine(() -> "finish(event=" + event.getType() + ")");
        this.helper.close();
        LOG.finest("Finished.");
    }

    private void onIncomingRequest(RequestEvent event, String operationName) {
        LOG.fine(() -> "onIncomingRequest(event=" + event.getType() + ", operationName=" + operationName + ")");
        ContainerRequest requestContext = event.getContainerRequest();
        Tracer tracer = this.openTelemetryService.getCurrentTracer();
        String queryParam = requestContext.getRequestUri().getQuery() == null ? "" : "?" + requestContext.getRequestUri().getQuery();
        SpanBuilder spanBuilder = tracer.spanBuilder(operationName).setSpanKind(SpanKind.SERVER).setAttribute(SemanticAttributes.HTTP_METHOD, (Object)requestContext.getMethod()).setAttribute(SemanticAttributes.HTTP_URL, (Object)requestContext.getRequestUri().toString()).setAttribute(SemanticAttributes.HTTP_TARGET, (Object)(requestContext.getUriInfo().getRequestUri().getPath() + queryParam)).setAttribute(SemanticAttributes.HTTP_SCHEME, (Object)requestContext.getRequestUri().getScheme()).setAttribute(SemanticAttributes.NET_HOST_NAME, (Object)requestContext.getRequestUri().getHost()).setAttribute(SemanticAttributes.HTTP_ROUTE, (Object)this.openTracingHelper.getHttpRoute(requestContext, this.resourceInfo)).setAttribute("component", "jaxrs");
        if (requestContext.getRequestUri().getPort() != -1) {
            spanBuilder.setAttribute(SemanticAttributes.NET_HOST_PORT, (Object)requestContext.getRequestUri().getPort());
        }
        this.openTracingHelper.augmentSpan(spanBuilder);
        Context spanContext = this.extractContext(requestContext);
        spanBuilder.setParent(spanContext);
        Span span = spanBuilder.startSpan();
        this.helper = PropagationHelper.start((Span)span, (Context)spanContext);
        requestContext.setProperty(PropagationHelper.class.getName(), (Object)this.helper);
        LOG.fine(() -> "Request tracing enabled for request=" + requestContext.getRequest() + " on uri=" + this.toString((UriInfo)requestContext.getUriInfo()));
    }

    private String toString(UriInfo uriInfo) {
        try {
            return uriInfo.getRequestUri().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid uriInfo: " + uriInfo, e);
        }
    }

    private Context extractContext(ContainerRequest request) {
        return this.openTelemetryService.getCurrentSdk().getPropagators().getTextMapPropagator().extract(Context.root(), (Object)request, (TextMapGetter)new TextMapGetter<ContainerRequest>(){

            public Iterable<String> keys(ContainerRequest containerRequest) {
                return containerRequest.getHeaders().keySet();
            }

            public String get(ContainerRequest containerRequest, String s) {
                return containerRequest.getHeaderString(s);
            }
        });
    }
}

