/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance;

import fish.payara.microprofile.faulttolerance.FaultToleranceMethodContext;
import fish.payara.microprofile.faulttolerance.policy.FaultTolerancePolicy;
import fish.payara.microprofile.faulttolerance.state.CircuitBreakerState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Tag;

public interface FaultToleranceMetrics {
    public static final FaultToleranceMetrics DISABLED = new FaultToleranceMetrics(){};
    public static final Tag[] NO_TAGS = new Tag[0];

    default public FaultToleranceMetrics boundTo(FaultToleranceMethodContext context, FaultTolerancePolicy policy) {
        if (policy.isMetricsEnabled) {
            String[] stringArray;
            if (policy.isFallbackPresent()) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "fallback";
                stringArray2[1] = "applied";
                stringArray = stringArray2;
                stringArray2[2] = "notApplied";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "fallback";
                stringArray = stringArray3;
                stringArray3[1] = "notDefined";
            }
            String[] fallbackTag = stringArray;
            this.register(Counter.class.getTypeName(), "ft.invocations.total", {"result", "valueReturned", "exceptionThrown"}, fallbackTag);
            if (policy.isRetryPresent()) {
                ArrayList<String> retryResultTag = new ArrayList<String>(Arrays.asList("retryResult", "valueReturned", "exceptionNotRetryable"));
                if (policy.retry.isMaxRetriesSet()) {
                    retryResultTag.add("maxRetriesReached");
                }
                if (policy.retry.isMaxDurationSet()) {
                    retryResultTag.add("maxDurationReached");
                }
                this.register(Counter.class.getTypeName(), "ft.retry.calls.total", {"retried", "true", "false"}, retryResultTag.toArray(new String[0]));
                this.register(Counter.class.getTypeName(), "ft.retry.retries.total", new String[0][]);
            }
            if (policy.isTimeoutPresent()) {
                this.register(Counter.class.getTypeName(), "ft.timeout.calls.total", new String[][]{{"timedOut", "true", "false"}});
                this.register(Histogram.class.getTypeName(), "ft.timeout.executionDuration", new String[0][]);
            }
            if (policy.isCircuitBreakerPresent()) {
                this.register(Counter.class.getTypeName(), "ft.circuitbreaker.calls.total", new String[][]{{"circuitBreakerResult", "success", "failure", "circuitBreakerOpen"}});
                CircuitBreakerState state = context.getState();
                this.register("ft.circuitbreaker.state.total", "nanoseconds", state::nanosOpen, "state", "open");
                this.register("ft.circuitbreaker.state.total", "nanoseconds", state::nanosHalfOpen, "state", "halfOpen");
                this.register("ft.circuitbreaker.state.total", "nanoseconds", state::nanosClosed, "state", "closed");
                this.register(Counter.class.getTypeName(), "ft.circuitbreaker.opened.total", new String[0][]);
            }
            if (policy.isBulkheadPresent()) {
                Object running;
                this.register(Counter.class.getTypeName(), "ft.bulkhead.calls.total", new String[][]{{"bulkheadResult", "accepted", "rejected"}});
                this.register(Histogram.class.getTypeName(), "ft.bulkhead.runningDuration", new String[0][]);
                if (policy.isAsynchronous()) {
                    running = context.getConcurrentExecutions();
                    this.register("ft.bulkhead.executionsRunning", null, ((BlockingQueue)running)::size, new String[0]);
                    AtomicInteger queuingOrRunning = context.getQueuingOrRunningPopulation();
                    this.register("ft.bulkhead.executionsWaiting", null, () -> Math.max(0, queuingOrRunning.get() - policy.bulkhead.value), new String[0]);
                    this.register(Histogram.class.getTypeName(), "ft.bulkhead.waitingDuration", new String[0][]);
                } else {
                    running = context.getQueuingOrRunningPopulation();
                    this.register("ft.bulkhead.executionsRunning", null, ((AtomicInteger)running)::get, new String[0]);
                }
            }
        }
        return this;
    }

    default public void register(String metric, String unit, LongSupplier gauge, String ... tag) {
    }

    default public void register(String metricType, String metric, String[] ... tags) {
    }

    default public void incrementCounter(String metric, Tag ... tags) {
    }

    default public void incrementCounter(String metric) {
        this.incrementCounter(metric, NO_TAGS);
    }

    default public void addToHistogram(String metric, long nanos, Tag ... tags) {
    }

    default public void addToHistogram(String metric, long nanos) {
        this.addToHistogram(metric, nanos, NO_TAGS);
    }

    default public void incrementInvocationsValueReturned() {
        this.incrementCounter("ft.invocations.total", new Tag("result", "valueReturned"), new Tag("fallback", this.getFallbackUsage().name()));
    }

    default public void incrementInvocationsExceptionThrown() {
        this.incrementCounter("ft.invocations.total", new Tag("result", "exceptionThrown"), new Tag("fallback", this.getFallbackUsage().name()));
    }

    default public FallbackUsage getFallbackUsage() {
        return FallbackUsage.notDefined;
    }

    default public void incrementRetryCallsValueReturned() {
        this.incrementCounter("ft.retry.calls.total", new Tag("retried", String.valueOf(this.isRetried())), new Tag("retryResult", "valueReturned"));
    }

    default public void incrementRetryCallsExceptionNotRetryable() {
        this.incrementCounter("ft.retry.calls.total", new Tag("retried", String.valueOf(this.isRetried())), new Tag("retryResult", "exceptionNotRetryable"));
    }

    default public void incrementRetryCallsMaxDurationReached() {
        this.incrementCounter("ft.retry.calls.total", new Tag("retried", String.valueOf(this.isRetried())), new Tag("retryResult", "maxDurationReached"));
    }

    default public void incrementRetryCallsMaxRetriesReached() {
        this.incrementCounter("ft.retry.calls.total", new Tag("retried", String.valueOf(this.isRetried())), new Tag("retryResult", "maxRetriesReached"));
    }

    default public void incrementRetryRetriesTotal() {
        this.incrementCounter("ft.retry.retries.total");
    }

    default public boolean isRetried() {
        return false;
    }

    default public void addTimeoutExecutionDuration(long nanos) {
        this.addToHistogram("ft.timeout.executionDuration", nanos);
    }

    default public void incrementTimeoutCallsTimedOutTotal() {
        this.incrementCounter("ft.timeout.calls.total", new Tag("timedOut", "true"));
    }

    default public void incrementTimeoutCallsNotTimedOutTotal() {
        this.incrementCounter("ft.timeout.calls.total", new Tag("timedOut", "false"));
    }

    default public void incrementCircuitbreakerCallsSucceededTotal() {
        this.incrementCounter("ft.circuitbreaker.calls.total", new Tag("circuitBreakerResult", "success"));
    }

    default public void incrementCircuitbreakerCallsFailedTotal() {
        this.incrementCounter("ft.circuitbreaker.calls.total", new Tag("circuitBreakerResult", "failure"));
    }

    default public void incrementCircuitbreakerCallsPreventedTotal() {
        this.incrementCounter("ft.circuitbreaker.calls.total", new Tag("circuitBreakerResult", "circuitBreakerOpen"));
    }

    default public void incrementCircuitbreakerOpenedTotal() {
        this.incrementCounter("ft.circuitbreaker.opened.total");
    }

    default public void incrementBulkheadCallsAcceptedTotal() {
        this.incrementCounter("ft.bulkhead.calls.total", new Tag("bulkheadResult", "accepted"));
    }

    default public void incrementBulkheadCallsRejectedTotal() {
        this.incrementCounter("ft.bulkhead.calls.total", new Tag("bulkheadResult", "rejected"));
    }

    default public void addBulkheadExecutionDuration(long nanos) {
        this.addToHistogram("ft.bulkhead.runningDuration", nanos);
    }

    default public void addBulkheadWaitingDuration(long nanos) {
        this.addToHistogram("ft.bulkhead.waitingDuration", nanos);
    }

    default public void incrementFallbackCallsTotal() {
    }

    public static enum FallbackUsage {
        applied,
        notApplied,
        notDefined;

    }
}

