/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.policy;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.policy.Policy;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.faulttolerance.Bulkhead;

public final class BulkheadPolicy
extends Policy {
    public final int value;
    public final int waitingTaskQueue;
    public final boolean exitIsOnCompletion;

    public BulkheadPolicy(Method annotatedMethod, int value, int waitingTaskQueue) {
        BulkheadPolicy.checkAtLeast(1L, annotatedMethod, Bulkhead.class, "value", value);
        BulkheadPolicy.checkAtLeast(0L, annotatedMethod, Bulkhead.class, "waitingTaskQueue", waitingTaskQueue);
        this.value = value;
        this.waitingTaskQueue = waitingTaskQueue;
        this.exitIsOnCompletion = annotatedMethod.getReturnType() == CompletionStage.class;
    }

    public static BulkheadPolicy create(InvocationContext context, FaultToleranceConfig config) {
        if (config.isAnnotationPresent(Bulkhead.class) && config.isEnabled(Bulkhead.class)) {
            Bulkhead annotation = config.getAnnotation(Bulkhead.class);
            return new BulkheadPolicy(context.getMethod(), config.value(annotation), config.waitingTaskQueue(annotation));
        }
        return null;
    }
}

