/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.policy;

import fish.payara.microprofile.faulttolerance.FaultToleranceConfig;
import fish.payara.microprofile.faulttolerance.policy.Policy;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;

public final class CircuitBreakerPolicy
extends Policy {
    private final Class<? extends Throwable>[] failOn;
    private final Class<? extends Throwable>[] skipOn;
    public final long delay;
    public final ChronoUnit delayUnit;
    public final int requestVolumeThreshold;
    public final double failureRatio;
    public final int successThreshold;

    public CircuitBreakerPolicy(Method annotatedMethod, Class<? extends Throwable>[] failOn, Class<? extends Throwable>[] skipOn, long delay, ChronoUnit delayUnit, int requestVolumeThreshold, double failureRatio, int successThreshold) {
        CircuitBreakerPolicy.checkAtLeast(0L, annotatedMethod, CircuitBreaker.class, "delay", delay);
        CircuitBreakerPolicy.checkAtLeast(1L, annotatedMethod, CircuitBreaker.class, "requestVolumeThreshold", requestVolumeThreshold);
        CircuitBreakerPolicy.checkAtLeast(0.0, annotatedMethod, CircuitBreaker.class, "failureRatio", failureRatio);
        CircuitBreakerPolicy.checkAtMost(1.0, annotatedMethod, CircuitBreaker.class, "failureRatio", failureRatio);
        CircuitBreakerPolicy.checkAtLeast(1L, annotatedMethod, CircuitBreaker.class, "successThreshold", successThreshold);
        this.failOn = failOn;
        this.skipOn = skipOn;
        this.delay = delay;
        this.delayUnit = delayUnit;
        this.requestVolumeThreshold = requestVolumeThreshold;
        this.failureRatio = failureRatio;
        this.successThreshold = successThreshold;
    }

    public static CircuitBreakerPolicy create(InvocationContext context, FaultToleranceConfig config) {
        if (config.isAnnotationPresent(CircuitBreaker.class) && config.isEnabled(CircuitBreaker.class)) {
            CircuitBreaker annotation = config.getAnnotation(CircuitBreaker.class);
            return new CircuitBreakerPolicy(context.getMethod(), config.failOn(annotation), config.skipOn(annotation), config.delay(annotation), config.delayUnit(annotation), config.requestVolumeThreshold(annotation), config.failureRatio(annotation), config.successThreshold(annotation));
        }
        return null;
    }

    public boolean isFailure(Throwable ex) {
        return !Policy.isCaught(ex, this.skipOn) && Policy.isCaught(ex, this.failOn);
    }
}

