/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.internal.notification.PayaraNotificationFactory;
import fish.payara.internal.notification.TimeUtil;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.notification.requesttracing.EventType;
import fish.payara.notification.requesttracing.RequestTrace;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.notification.requesttracing.RequestTraceSpanLog;
import fish.payara.notification.requesttracing.RequestTracingNotificationData;
import fish.payara.nucleus.config.ClusteredConfig;
import fish.payara.nucleus.eventbus.ClusterMessage;
import fish.payara.nucleus.eventbus.EventBus;
import fish.payara.nucleus.events.HazelcastEvents;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import fish.payara.nucleus.requesttracing.RequestTraceSpanStore;
import fish.payara.nucleus.requesttracing.RequestTraceStoreCleanupTask;
import fish.payara.nucleus.requesttracing.configuration.RequestTracingServiceConfiguration;
import fish.payara.nucleus.requesttracing.domain.execoptions.RequestTracingExecutionOptions;
import fish.payara.nucleus.requesttracing.events.RequestTracingEvents;
import fish.payara.nucleus.requesttracing.sampling.AdaptiveSampleFilter;
import fish.payara.nucleus.requesttracing.sampling.SampleFilter;
import fish.payara.nucleus.requesttracing.store.RequestTraceStoreFactory;
import fish.payara.nucleus.requesttracing.store.RequestTraceStoreInterface;
import io.opentracing.tag.Tag;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.messaging.Topic;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="requesttracing-service")
@RunLevel(value=10)
public class RequestTracingService
implements EventListener,
ConfigListener,
MonitoringDataSource,
MonitoringWatchSource {
    private static final Logger logger = Logger.getLogger(RequestTracingService.class.getCanonicalName());
    private static final String DURATION = "Duration";
    public static final String EVENT_BUS_LISTENER_NAME = "RequestTracingEvents";
    private static final int SECOND = 1;
    private static final int MINUTE = 60;
    private static final int HOUR = 3600;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    RequestTracingServiceConfiguration configuration;
    @Inject
    private Events events;
    @Inject
    private EventBus eventBus;
    @Inject
    private Domain domain;
    @Inject
    private Server server;
    @Inject
    ServerEnvironment env;
    @Inject
    Transactions transactions;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Topic<PayaraNotification> notificationEventBus;
    @Inject
    private PayaraNotificationFactory notificationFactory;
    @Inject
    RequestTraceSpanStore requestEventStore;
    @Inject
    private HazelcastCore hazelcast;
    @Inject
    private ClusteredConfig clusteredConfig;
    @Inject
    private PayaraExecutorService payaraExecutorService;
    private RequestTracingExecutionOptions executionOptions = new RequestTracingExecutionOptions();
    private RequestTraceStoreInterface historicRequestTraceStore;
    private RequestTraceStoreInterface requestTraceStore;
    private final ConcurrentLinkedQueue<RequestTrace> uncollectedTraces = new ConcurrentLinkedQueue();
    private final Map<String, Integer> activeCollectionGroups = new ConcurrentHashMap<String, Integer>();
    private SampleFilter sampleFilter;

    @PostConstruct
    void postConstruct() {
        this.events.register((EventListener)this);
        this.configuration = (RequestTracingServiceConfiguration)this.habitat.getService(RequestTracingServiceConfiguration.class, new Annotation[0]);
        this.payaraExecutorService = (PayaraExecutorService)this.habitat.getService(PayaraExecutorService.class, new Annotation[0]);
    }

    public void event(EventListener.Event event) {
        if (this.hazelcast.isEnabled()) {
            if (event.is(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE)) {
                this.bootstrapRequestTracingService();
            }
        } else if (event.is(EventTypes.SERVER_READY)) {
            this.bootstrapRequestTracingService();
        }
        if (event.is(HazelcastEvents.HAZELCAST_SHUTDOWN_COMPLETE)) {
            this.bootstrapRequestTracingService();
        }
        this.transactions.addListenerForType(RequestTracingServiceConfiguration.class, (ConfigListener)this);
    }

    public void bootstrapRequestTracingService() {
        if (this.configuration != null) {
            this.executionOptions.setEnabled(Boolean.parseBoolean(this.configuration.getEnabled()));
            this.executionOptions.setSampleRate(Double.valueOf(this.configuration.getSampleRate()));
            this.executionOptions.setAdaptiveSamplingEnabled(Boolean.parseBoolean(this.configuration.getAdaptiveSamplingEnabled()));
            this.executionOptions.setAdaptiveSamplingTargetCount(Integer.valueOf(this.configuration.getAdaptiveSamplingTargetCount()));
            this.executionOptions.setAdaptiveSamplingTimeValue(Integer.valueOf(this.configuration.getAdaptiveSamplingTimeValue()));
            this.executionOptions.setAdaptiveSamplingTimeUnit(TimeUnit.valueOf(this.configuration.getAdaptiveSamplingTimeUnit()));
            this.executionOptions.setApplicationsOnlyEnabled(Boolean.parseBoolean(this.configuration.getApplicationsOnlyEnabled()));
            this.executionOptions.setThresholdUnit(TimeUnit.valueOf(this.configuration.getThresholdUnit()));
            this.executionOptions.setThresholdValue(Long.parseLong(this.configuration.getThresholdValue()));
            this.executionOptions.setSampleRateFirstEnabled(Boolean.parseBoolean(this.configuration.getSampleRateFirstEnabled()));
            this.executionOptions.setTraceStoreSize(Integer.parseInt(this.configuration.getTraceStoreSize()));
            this.executionOptions.setTraceStoreTimeout(TimeUtil.setStoreTimeLimit((String)this.configuration.getTraceStoreTimeout()));
            this.executionOptions.setReservoirSamplingEnabled(Boolean.parseBoolean(this.configuration.getReservoirSamplingEnabled()));
            this.executionOptions.setHistoricTraceStoreEnabled(Boolean.parseBoolean(this.configuration.getHistoricTraceStoreEnabled()));
            this.executionOptions.setHistoricTraceStoreSize(Integer.parseInt(this.configuration.getHistoricTraceStoreSize()));
            this.executionOptions.setHistoricTraceStoreTimeout(TimeUtil.setStoreTimeLimit((String)this.configuration.getHistoricTraceStoreTimeout()));
            this.bootstrapNotifierList();
        }
        if (this.executionOptions != null && this.executionOptions.isEnabled().booleanValue()) {
            long period;
            this.sampleFilter = this.executionOptions.getAdaptiveSamplingEnabled() != false ? new AdaptiveSampleFilter(this.executionOptions.getSampleRate(), this.executionOptions.getAdaptiveSamplingTargetCount(), this.executionOptions.getAdaptiveSamplingTimeValue(), this.executionOptions.getAdaptiveSamplingTimeUnit()) : new SampleFilter(this.executionOptions.getSampleRate());
            if (this.executionOptions.isHistoricTraceStoreEnabled().booleanValue()) {
                this.historicRequestTraceStore = RequestTraceStoreFactory.getStore(this.executionOptions.getReservoirSamplingEnabled(), true);
                this.initStoreSize(this.historicRequestTraceStore, this.executionOptions::getHistoricTraceStoreSize, "historicRequestTraceStoreSize");
                if (this.executionOptions.getTraceStoreTimeout() != null && this.executionOptions.getTraceStoreTimeout() > 0L && !this.executionOptions.getReservoirSamplingEnabled().booleanValue()) {
                    period = this.executionOptions.getTraceStoreTimeout() > 500L ? 500L : this.executionOptions.getTraceStoreTimeout();
                    this.payaraExecutorService.scheduleAtFixedRate((Runnable)new RequestTraceStoreCleanupTask(this.executionOptions.getTraceStoreTimeout(), this.historicRequestTraceStore), 0L, period, TimeUnit.SECONDS);
                }
            }
            this.requestTraceStore = RequestTraceStoreFactory.getStore(this.executionOptions.getReservoirSamplingEnabled(), false);
            this.initStoreSize(this.requestTraceStore, this.executionOptions::getTraceStoreSize, "requestTraceStoreSize");
            if (this.executionOptions.getTraceStoreTimeout() != null && this.executionOptions.getTraceStoreTimeout() > 0L && !this.executionOptions.getReservoirSamplingEnabled().booleanValue()) {
                period = this.executionOptions.getTraceStoreTimeout() > 500L ? 500L : this.executionOptions.getTraceStoreTimeout();
                this.payaraExecutorService.scheduleAtFixedRate((Runnable)new RequestTraceStoreCleanupTask(this.executionOptions.getTraceStoreTimeout(), this.requestTraceStore), 0L, period, TimeUnit.SECONDS);
            }
            logger.log(Level.INFO, "Payara Request Tracing Service Started with configuration: {0}", this.executionOptions);
        } else {
            this.clusteredConfig.clearSharedConfiguration("requestTraceStoreSize");
            this.clusteredConfig.clearSharedConfiguration("historicRequestTraceStore");
        }
    }

    private void initStoreSize(RequestTraceStoreInterface store, IntSupplier size, String clusteredConfigProperty) {
        if (store.isShared()) {
            store.setSize(() -> this.clusteredConfig.getSharedConfiguration(clusteredConfigProperty, size.getAsInt(), Integer::max));
        } else {
            this.clusteredConfig.clearSharedConfiguration(clusteredConfigProperty);
            store.setSize(size);
        }
    }

    public void bootstrapNotifierList() {
        this.executionOptions.clearNotifiers();
        if (this.configuration.getNotifierList() != null) {
            this.configuration.getNotifierList().forEach(this.executionOptions::enableNotifier);
        }
    }

    public UUID getConversationID() {
        return this.requestEventStore.getTraceID();
    }

    public UUID getStartingTraceID() {
        return ((RequestTraceSpan)this.requestEventStore.getTrace().getTraceSpans().getFirst()).getId();
    }

    public void setTraceId(UUID newID) {
        this.requestEventStore.setTraceId(newID);
    }

    public boolean isTraceInProgress() {
        return this.requestEventStore.isTraceInProgress();
    }

    public RequestTraceSpan startTrace(String traceName) {
        return this.startTrace(new RequestTraceSpan(EventType.TRACE_START, traceName));
    }

    public RequestTraceSpan startTrace(RequestTraceSpan span) {
        if (this.shouldStartTrace()) {
            span.addSpanTag("Server", this.server.getName());
            span.addSpanTag("Domain", this.domain.getName());
            this.requestEventStore.storeEvent(span);
            return span;
        }
        return null;
    }

    public RequestTraceSpan startTrace(RequestTraceSpan span, long timestampMillis) {
        if (this.shouldStartTrace()) {
            span.addSpanTag("Server", this.server.getName());
            span.addSpanTag("Domain", this.domain.getName());
            this.requestEventStore.storeEvent(span, timestampMillis);
            return span;
        }
        return null;
    }

    public RequestTraceSpan startTrace(UUID propagatedTraceId, UUID propagatedParentId, RequestTraceSpan.SpanContextRelationshipType propagatedRelationshipType, String traceName) {
        if (!this.isRequestTracingEnabled()) {
            return null;
        }
        RequestTraceSpan span = new RequestTraceSpan(EventType.PROPAGATED_TRACE, traceName, propagatedTraceId, propagatedParentId, propagatedRelationshipType);
        span.addSpanTag("Server", this.server.getName());
        span.addSpanTag("Domain", this.domain.getName());
        this.requestEventStore.storeEvent(span);
        return span;
    }

    public void traceSpan(RequestTraceSpan requestEvent) {
        if (this.isRequestTracingEnabled() && this.isTraceInProgress()) {
            this.traceOrEnd(requestEvent);
        }
    }

    public void traceSpan(RequestTraceSpan requestEvent, long timestampMillis) {
        if (this.isRequestTracingEnabled() && this.isTraceInProgress()) {
            this.traceOrEnd(requestEvent, timestampMillis);
        }
    }

    private void traceOrEnd(RequestTraceSpan requestEvent) {
        if (this.spanIsRootSpan(requestEvent)) {
            this.endTrace();
        } else {
            this.requestEventStore.storeEvent(requestEvent);
        }
    }

    private void traceOrEnd(RequestTraceSpan requestEvent, long timestampMillis) {
        if (this.spanIsRootSpan(requestEvent)) {
            this.endTrace(timestampMillis);
        } else {
            this.requestEventStore.storeEvent(requestEvent, timestampMillis);
        }
    }

    private boolean spanIsRootSpan(RequestTraceSpan requestEvent) {
        return !this.requestEventStore.getTrace().getTraceSpans().isEmpty() && ((RequestTraceSpan)this.requestEventStore.getTrace().getTraceSpans().getFirst()).equals(requestEvent);
    }

    public boolean shouldStartTrace() {
        if (!this.isRequestTracingEnabled()) {
            return false;
        }
        if (this.executionOptions.getApplicationsOnlyEnabled().booleanValue() && Thread.currentThread().getName().matches("admin-thread-pool::admin-listener\\([0-9]+\\)")) {
            return false;
        }
        return this.executionOptions.getSampleRateFirstEnabled() == false || this.sampleFilter.sample();
    }

    public void endTrace() {
        if (!this.isRequestTracingEnabled() || !this.isTraceInProgress()) {
            return;
        }
        this.requestEventStore.endTrace();
        this.processTraceEnd();
    }

    public void endTrace(long timestampMillis) {
        if (!this.isRequestTracingEnabled() || !this.isTraceInProgress()) {
            return;
        }
        this.requestEventStore.endTrace(timestampMillis);
        this.processTraceEnd();
    }

    public void processSpan(RequestTraceSpan finishedSpan) {
        if (!this.isRequestTracingEnabled()) {
            return;
        }
        this.requestEventStore.storeEvent(finishedSpan, 0L);
        this.requestEventStore.endTrace(finishedSpan.getTimeOccured() + finishedSpan.getSpanDuration());
    }

    private void processTraceEnd() {
        Long thresholdValueInNanos = this.getThresholdValueInNanos();
        long elapsedTime = this.requestEventStore.getElapsedTime();
        long elapsedTimeInNanos = TimeUnit.NANOSECONDS.convert(elapsedTime, TimeUnit.MILLISECONDS);
        if (elapsedTimeInNanos - thresholdValueInNanos > 0L) {
            if (!this.executionOptions.getSampleRateFirstEnabled().booleanValue() && !this.sampleFilter.sample()) {
                this.requestEventStore.flushStore();
                return;
            }
            if (this.uncollectedTraces.size() >= 50) {
                this.uncollectedTraces.poll();
            }
            RequestTrace requestTrace = this.requestEventStore.getTrace();
            this.uncollectedTraces.add(requestTrace);
            Runnable addTask = () -> {
                RequestTrace removedTrace = this.requestTraceStore.addTrace(requestTrace);
                if (this.executionOptions.isHistoricTraceStoreEnabled().booleanValue()) {
                    this.historicRequestTraceStore.addTrace(requestTrace, removedTrace);
                }
                if (removedTrace != null) {
                    if (this.hazelcast.isEnabled()) {
                        this.eventBus.publish(EVENT_BUS_LISTENER_NAME, new ClusterMessage<String>(RequestTracingEvents.STORE_FULL.toString()));
                    } else {
                        this.events.send(new EventListener.Event(RequestTracingEvents.STORE_FULL));
                    }
                }
            };
            this.payaraExecutorService.submit(addTask);
            Set<String> enabledNotifiers = this.getExecutionOptions().getEnabledNotifiers();
            PayaraNotification notification = this.notificationFactory.newBuilder().whitelist(enabledNotifiers.toArray(new String[0])).subject("Request execution time: " + elapsedTime + "(ms) exceeded the acceptable threshold").message(requestTrace.toString()).data((Serializable)new RequestTracingNotificationData(requestTrace)).build();
            this.notificationEventBus.publish((Object)notification);
        }
        this.requestEventStore.flushStore();
    }

    public void addSpanLog(RequestTraceSpanLog spanLog) {
        if (!this.isRequestTracingEnabled() || !this.isTraceInProgress()) {
            return;
        }
        this.requestEventStore.getTrace().addSpanLog(spanLog);
    }

    public Long getThresholdValueInNanos() {
        if (this.executionOptions != null) {
            return TimeUnit.NANOSECONDS.convert(this.executionOptions.getThresholdValue(), this.executionOptions.getThresholdUnit());
        }
        return null;
    }

    public boolean isRequestTracingEnabled() {
        return this.executionOptions != null && this.executionOptions.isEnabled() != false;
    }

    public RequestTracingExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        boolean isCurrentInstanceMatchTarget = false;
        if (this.env.isInstance()) {
            isCurrentInstanceMatchTarget = true;
        } else {
            for (PropertyChangeEvent pe : events) {
                ConfigBeanProxy proxy;
                for (proxy = (ConfigBeanProxy)pe.getSource(); proxy != null && !(proxy instanceof Config); proxy = proxy.getParent()) {
                }
                if (proxy == null || !((Config)proxy).isDas()) continue;
                isCurrentInstanceMatchTarget = true;
                break;
            }
        }
        if (isCurrentInstanceMatchTarget) {
            return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

                public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                    if (changedType.equals(RequestTracingServiceConfiguration.class)) {
                        RequestTracingService.this.configuration = (RequestTracingServiceConfiguration)changedInstance;
                    }
                    return null;
                }
            }, (Logger)logger);
        }
        return null;
    }

    public RequestTraceStoreInterface getHistoricRequestTraceStore() {
        return this.historicRequestTraceStore;
    }

    public RequestTraceStoreInterface getRequestTraceStore() {
        return this.requestTraceStore;
    }

    public void collect(MonitoringWatchCollector collector) {
        if ("true".equals(this.configuration.getEnabled())) {
            long thresholdMillis = this.getConfigurationThresholdInMillis();
            collector.watch((CharSequence)"ns:trace @:* Duration", "Request Trace Duration", "ms").amber(thresholdMillis, (Number)-30, false, null, null, false).red(thresholdMillis, (Number)10, true, null, null, false).green(-(thresholdMillis / 2L), (Number)1, false, null, null, false);
        }
    }

    private long getConfigurationThresholdInMillis() {
        return TimeUnit.MILLISECONDS.convert(Long.parseLong(this.configuration.getThresholdValue()), TimeUnit.valueOf(this.configuration.getThresholdUnit()));
    }

    @MonitoringData(ns="trace")
    public void collect(MonitoringDataCollector collector) {
        for (String group : this.activeCollectionGroups.keySet()) {
            collector.group((CharSequence)group).collect((CharSequence)DURATION, 0L);
            this.activeCollectionGroups.compute(group, (key, value) -> value <= 1 ? null : Integer.valueOf(value - 1));
        }
        long thresholdInMillis = this.getConfigurationThresholdInMillis();
        RequestTrace trace = this.uncollectedTraces.poll();
        while (trace != null) {
            String group = RequestTracingService.collectTrace(collector, trace, thresholdInMillis);
            if (group != null) {
                this.activeCollectionGroups.compute(group, (key, value) -> 35);
            }
            trace = this.uncollectedTraces.poll();
        }
    }

    private static String collectTrace(MonitoringDataCollector tracingCollector, RequestTrace trace, long threshold) {
        try {
            UUID traceId = trace.getTraceId();
            if (traceId != null) {
                String group = RequestTracingService.metricGroupName(trace);
                long durationMillis = ((RequestTraceSpan)trace.getTraceSpans().getFirst()).getSpanDuration() / 1000000L;
                RequestTraceSpan annotationSpan = (RequestTraceSpan)trace.getTraceSpans().getLast();
                ArrayList<String> attrs = new ArrayList<String>();
                attrs.add("Threshold");
                attrs.add(String.valueOf(threshold));
                attrs.add("Operation");
                attrs.add(annotationSpan.getEventName());
                attrs.add("Start");
                attrs.add(String.valueOf(annotationSpan.getStartInstant().toEpochMilli()));
                attrs.add("End");
                attrs.add(String.valueOf(annotationSpan.getTraceEndTime().toEpochMilli()));
                for (Map.Entry tag : annotationSpan.getSpanTags().entrySet()) {
                    if (tag.getKey() instanceof Tag) {
                        attrs.add(((Tag)tag.getKey()).getKey());
                    } else {
                        attrs.add(tag.getKey().toString());
                    }
                    attrs.add((String)tag.getValue());
                }
                tracingCollector.group((CharSequence)group).collect((CharSequence)DURATION, durationMillis).annotate((CharSequence)DURATION, durationMillis, attrs.toArray(new String[0]));
                return group;
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Failed to collect trace", ex);
        }
        return null;
    }

    public static String metricGroupName(RequestTrace trace) {
        return RequestTracingService.stripPackageName(((RequestTraceSpan)trace.getTraceSpans().getLast()).getEventName());
    }

    public static String stripPackageName(String eventName) {
        int javaMethodDot = eventName.lastIndexOf(46);
        int httpMethodDivider = eventName.indexOf(58);
        return javaMethodDot < 0 || httpMethodDivider < 0 ? eventName : eventName.substring(0, httpMethodDivider) + "_" + eventName.substring(eventName.lastIndexOf(46, javaMethodDot - 1) + 1);
    }
}

