/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.StringUtils;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.PayaraNotifier;
import fish.payara.nucleus.requesttracing.configuration.RequestTracingServiceConfiguration;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-requesttracing-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.requesttracing.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=RequestTracingServiceConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-requesttracing-configuration", description="List Request Tracing Configuration")})
public class GetRequestTracingConfiguration
implements AdminCommand {
    @Inject
    ServiceLocator habitat;
    @Inject
    private Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    String target;

    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config named: " + this.target);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ActionReport mainActionReport = context.getActionReport();
        RequestTracingServiceConfiguration configuration = (RequestTracingServiceConfiguration)config.getExtensionByType(RequestTracingServiceConfiguration.class);
        this.writeVariableToActionReport(mainActionReport, "Enabled?", configuration.getEnabled());
        if (Boolean.parseBoolean(configuration.getEnabled())) {
            this.writeVariableToActionReport(mainActionReport, "Sample Rate", configuration.getSampleRate());
            this.writeVariableToActionReport(mainActionReport, "Adaptive Sampling Enabled?", configuration.getAdaptiveSamplingEnabled());
            if (Boolean.parseBoolean(configuration.getAdaptiveSamplingEnabled())) {
                this.writeVariableToActionReport(mainActionReport, "Adaptive Sampling Target Count", configuration.getAdaptiveSamplingTargetCount());
                this.writeVariableToActionReport(mainActionReport, "Adaptive Sampling Time Value", configuration.getAdaptiveSamplingTimeValue());
                this.writeVariableToActionReport(mainActionReport, "Adaptive Sampling Time Unit", configuration.getAdaptiveSamplingTimeUnit());
            }
            this.writeVariableToActionReport(mainActionReport, "Application Only?", configuration.getApplicationsOnlyEnabled());
            this.writeVariableToActionReport(mainActionReport, "Threshold Value", configuration.getThresholdValue());
            this.writeVariableToActionReport(mainActionReport, "Threshold Unit", configuration.getThresholdUnit());
            this.writeVariableToActionReport(mainActionReport, "Sample Rate First?", configuration.getSampleRateFirstEnabled());
            this.writeVariableToActionReport(mainActionReport, "Reservoir Sampling Enabled?", configuration.getReservoirSamplingEnabled());
            this.writeVariableToActionReport(mainActionReport, "Trace Store Size", configuration.getTraceStoreSize());
            if (StringUtils.ok((String)configuration.getTraceStoreTimeout())) {
                this.writeVariableToActionReport(mainActionReport, "Trace Store Timeout (secs)", configuration.getTraceStoreTimeout());
            }
            this.writeVariableToActionReport(mainActionReport, "Historic Trace Store Enabled?", configuration.getHistoricTraceStoreEnabled());
            if (Boolean.parseBoolean(configuration.getHistoricTraceStoreEnabled())) {
                this.writeVariableToActionReport(mainActionReport, "Historic Trace Store Size", configuration.getHistoricTraceStoreSize());
                if (StringUtils.ok((String)configuration.getHistoricTraceStoreTimeout())) {
                    this.writeVariableToActionReport(mainActionReport, "Historic Trace Store Timeout (secs)", configuration.getHistoricTraceStoreTimeout());
                }
            }
        }
        Properties mainExtraProps = new Properties();
        HashMap<String, String> mainExtraPropsMap = new HashMap<String, String>();
        mainExtraPropsMap.put("enabled", configuration.getEnabled());
        mainExtraPropsMap.put("sampleRate", configuration.getSampleRate());
        mainExtraPropsMap.put("adaptiveSamplingEnabled", configuration.getAdaptiveSamplingEnabled());
        mainExtraPropsMap.put("adaptiveSamplingTargetCount", configuration.getAdaptiveSamplingTargetCount());
        mainExtraPropsMap.put("adaptiveSamplingTimeValue", configuration.getAdaptiveSamplingTimeValue());
        mainExtraPropsMap.put("adaptiveSamplingTimeUnit", configuration.getAdaptiveSamplingTimeUnit());
        mainExtraPropsMap.put("applicationsOnlyEnabled", configuration.getApplicationsOnlyEnabled());
        mainExtraPropsMap.put("thresholdValue", configuration.getThresholdValue());
        mainExtraPropsMap.put("thresholdUnit", configuration.getThresholdUnit());
        mainExtraPropsMap.put("sampleRateFirstEnabled", configuration.getSampleRateFirstEnabled());
        mainExtraPropsMap.put("traceStoreSize", configuration.getTraceStoreSize());
        mainExtraPropsMap.put("traceStoreTimeout", configuration.getTraceStoreTimeout());
        mainExtraPropsMap.put("reservoirSamplingEnabled", configuration.getReservoirSamplingEnabled());
        mainExtraPropsMap.put("historicTraceStoreEnabled", configuration.getHistoricTraceStoreEnabled());
        mainExtraPropsMap.put("historicTraceStoreSize", configuration.getHistoricTraceStoreSize());
        mainExtraPropsMap.put("historicTraceStoreTimeout", configuration.getHistoricTraceStoreTimeout());
        mainExtraProps.put("requestTracingConfiguration", mainExtraPropsMap);
        mainActionReport.setExtraProperties(mainExtraProps);
        mainActionReport.appendMessage("Below are the configuration details of each notifier listed by its name.");
        mainActionReport.appendMessage(StringUtils.EOL);
        ActionReport notifiersActionReport = mainActionReport.addSubActionsReport();
        List allServiceHandles = this.habitat.getAllServiceHandles(PayaraNotifier.class, new Annotation[0]);
        if (configuration.getNotifierList().isEmpty()) {
            notifiersActionReport.setMessage("No notifier defined");
        } else {
            String[] headers = new String[]{"Notifier Name", "Notifier Enabled"};
            ColumnFormatter columnFormatter = new ColumnFormatter(headers);
            List<String> notifiers = configuration.getNotifierList();
            Properties notifierExtraProps = new Properties();
            for (ServiceHandle serviceHandle : allServiceHandles) {
                String notifierClassName = serviceHandle.getActiveDescriptor().getImplementationClass().getSimpleName();
                String notifierName = NotifierUtils.getNotifierName((ActiveDescriptor)serviceHandle.getActiveDescriptor());
                Object[] values = new Object[]{notifierName, notifiers.contains(notifierName)};
                columnFormatter.addRow(values);
                HashMap<String, Object> notifierExtraPropsMap = new HashMap<String, Object>();
                notifierExtraPropsMap.put("notifierName", values[0]);
                notifierExtraPropsMap.put("notifierEnabled", values[1]);
                notifierExtraProps.put("getRequesttracingConfiguration" + notifierClassName, notifierExtraPropsMap);
                notifiersActionReport.setExtraProperties(notifierExtraProps);
            }
            notifiersActionReport.setMessage(columnFormatter.toString());
        }
        mainActionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void writeVariableToActionReport(ActionReport report, String variableName, String variableValue) {
        report.appendMessage(String.format("Request Tracing Service %s: %s\n", variableName, variableValue));
    }
}

