/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.sampling;

import fish.payara.nucleus.requesttracing.sampling.SampleFilter;
import java.time.Clock;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class AdaptiveSampleFilter
extends SampleFilter {
    private static final Logger LOGGER = Logger.getLogger(AdaptiveSampleFilter.class.getName());
    private final int targetCount;
    private final long targetTimeInMillis;
    private volatile Queue<Long> sampleTimes;
    private boolean allowSampleRateChanging;
    protected Clock clock;

    public AdaptiveSampleFilter(double sampleRate, Integer targetCount, Integer targetTimeValue, TimeUnit targetTimeUnit) {
        super(sampleRate);
        if (targetCount == null || targetTimeValue == null || targetTimeUnit == null) {
            throw new IllegalArgumentException(this.getClass().getCanonicalName() + " requires a non null targetCount, targetTimeValue and targetTimeUnit.");
        }
        this.targetCount = targetCount;
        this.targetTimeInMillis = TimeUnit.MILLISECONDS.convert(targetTimeValue.intValue(), targetTimeUnit);
        this.sampleTimes = new ConcurrentLinkedQueue<Long>();
        this.sampleRate = sampleRate;
        this.allowSampleRateChanging = false;
        this.clock = Clock.systemUTC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sample() {
        boolean sample = super.sample();
        long occurringTime = this.clock.millis();
        this.sampleTimes.add(occurringTime);
        long timeWindowStartMillis = occurringTime - this.targetTimeInMillis;
        Queue<Long> queue = this.sampleTimes;
        synchronized (queue) {
            Long samplePeek = this.sampleTimes.peek();
            while (samplePeek < timeWindowStartMillis || samplePeek == null) {
                this.sampleTimes.poll();
                this.allowSampleRateChanging = true;
                LOGGER.finer("Sample rate changing was enabled as the target time has elapsed.");
                samplePeek = this.sampleTimes.peek();
            }
        }
        if (this.sampleTimes.size() > 3) {
            double requiredSampleRate = Math.min(1.0, Math.max(0.0, (double)this.targetCount / (double)this.sampleTimes.size()));
            if (this.allowSampleRateChanging) {
                LOGGER.finest(String.format("The sample rate was changed from %4.1f to %4.1f, as in the last time period %d requests were received.", this.sampleRate, requiredSampleRate, this.sampleTimes.size()));
                this.sampleRate = requiredSampleRate;
            }
        }
        return sample;
    }
}

