/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.store;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public class IterableThreadLocal<T>
extends ThreadLocal<T>
implements Iterable<Map.Entry<Thread, T>> {
    private final Map<Thread, T> entries;
    private final Supplier<? extends T> initialValue;

    public IterableThreadLocal(Supplier<? extends T> initialValue) {
        this.initialValue = initialValue;
        this.entries = Collections.synchronizedMap(new WeakHashMap());
    }

    @Override
    protected T initialValue() {
        Object value = this.initialValue != null ? this.initialValue.get() : super.initialValue();
        this.entries.put(Thread.currentThread(), value);
        return value;
    }

    @Override
    public void set(T value) {
        super.set(value);
        this.entries.put(Thread.currentThread(), value);
    }

    @Override
    public void remove() {
        super.remove();
        this.entries.remove(Thread.currentThread());
    }

    @Override
    public Iterator<Map.Entry<Thread, T>> iterator() {
        return this.entries.entrySet().iterator();
    }
}

