/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.AppUtil;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class ApplicationHandlers {
    private static final String PATH_APPLICATIONS_APPLICATION = "/applications/application/";
    private static final String REST_URL = "REST_URL";
    private static final String NAME_CONFIG_NAME = "configName";
    private static final String NAME_RESULT = "result";

    public static void getDeployedAppsInfo(HandlerContext handlerCtx) {
        Map appPropsMap = (Map)handlerCtx.getInputValue("appPropsMap");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        TreeSet<String> filters = new TreeSet<String>();
        filters.add("");
        if (GuiUtil.isEmpty(filterValue)) {
            filterValue = null;
        }
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        if (appPropsMap == null) {
            handlerCtx.setOutputValue(NAME_RESULT, result);
            return;
        }
        ArrayList keys = new ArrayList(appPropsMap.keySet());
        Collections.sort(keys);
        String prefix = GuiUtil.getSessionValue(REST_URL) + PATH_APPLICATIONS_APPLICATION;
        for (String oneAppName : keys) {
            try {
                String engines = (String)appPropsMap.get(oneAppName);
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("name", oneAppName);
                String encodedName = URLEncoder.encode(oneAppName, "UTF-8");
                oneRow.put("encodedName", encodedName);
                oneRow.put("selected", false);
                oneRow.put("enableURL", DeployUtil.getTargetEnableInfo(oneAppName, true, true));
                oneRow.put("sniffers", engines);
                oneRow.put("deploymentOrder", RestUtil.getAttributesMap(prefix + encodedName).get("deploymentOrder"));
                oneRow.put("deploymentTime", RestUtil.getAttributesMap(prefix + encodedName).get("deploymentTime"));
                oneRow.put("deploymentOccuranceTime", DateFormat.getDateTimeInstance().format(new Date(Long.valueOf((String)RestUtil.getAttributesMap(prefix + encodedName).get("timeDeployed")))));
                List<String> sniffersList = GuiUtil.parseStringList(engines, ",");
                oneRow.put("sniffersList", sniffersList);
                for (int ix = 0; ix < sniffersList.size(); ++ix) {
                    filters.add(sniffersList.get(ix));
                }
                if (filterValue != null && !sniffersList.contains(filterValue)) continue;
                ApplicationHandlers.getLaunchInfo(oneAppName, null, oneRow);
                result.add(oneRow);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getDeployedAppsInfo") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) continue;
                ex.printStackTrace();
            }
        }
        handlerCtx.setOutputValue(NAME_RESULT, result);
        handlerCtx.setOutputValue("filters", new ArrayList(filters));
    }

    public static void getSubComponents(HandlerContext handlerCtx) {
        ArrayList<Map<String, Object>> result;
        block6: {
            result = new ArrayList<Map<String, Object>>();
            try {
                String appName = (String)handlerCtx.getInputValue("appName");
                String encodedAppName = URLEncoder.encode(appName, "UTF-8");
                List modules = (List)handlerCtx.getInputValue("moduleList");
                for (String oneModule : modules) {
                    String encodedModuleName = URLEncoder.encode(oneModule, "UTF-8");
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    List<String> snifferList = AppUtil.getSnifferListOfModule(encodedAppName, encodedModuleName);
                    String moduleName = oneModule;
                    oneRow.put("moduleName", moduleName);
                    oneRow.put("name", " ----------- ");
                    oneRow.put("type", " ----------- ");
                    oneRow.put("hasEndpoint", false);
                    oneRow.put("hasLaunch", false);
                    oneRow.put("hasAppClientLaunch", false);
                    oneRow.put("hasAppClientStub", false);
                    oneRow.put("sniffers", snifferList.toString());
                    if (snifferList.contains("web")) {
                        String endpoint = GuiUtil.getSessionValue(REST_URL) + PATH_APPLICATIONS_APPLICATION + encodedAppName + "/get-context-root.xml?modulename=" + encodedModuleName;
                        Map map = (Map)RestUtil.restRequest(endpoint, null, "GET", null, false).get("data");
                        Map props = (Map)map.get("properties");
                        String contextRoot = (String)props.get("contextRoot");
                        ApplicationHandlers.getLaunchInfo(appName, contextRoot, oneRow);
                    }
                    if (snifferList.contains("appclient")) {
                        String jwEnabled = RestUtil.getPropValue(GuiUtil.getSessionValue(REST_URL) + PATH_APPLICATIONS_APPLICATION + encodedAppName, "java-web-start-enabled", handlerCtx);
                        if (GuiUtil.isEmpty(jwEnabled) || jwEnabled.equals("true")) {
                            List<String> targetList = DeployUtil.getApplicationTarget(appName, "application-ref");
                            oneRow.put("hasAppClientLaunch", !targetList.isEmpty());
                        }
                        oneRow.put("hasAppClientStub", true);
                    }
                    result.add(oneRow);
                    ApplicationHandlers.getSubComponentDetail(appName, moduleName, snifferList, result);
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getSubComponents") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block6;
                ex.printStackTrace();
            }
        }
        handlerCtx.setOutputValue(NAME_RESULT, result);
    }

    private static List<Map<String, Object>> getSubComponentDetail(String appName, String moduleName, List<String> snifferList, List<Map<String, Object>> result) {
        block7: {
            try {
                String encodedAppName = URLEncoder.encode(appName, "UTF-8");
                String encodedModuleName = URLEncoder.encode(moduleName, "UTF-8");
                Map<?, ?> wsAppMap = null;
                if (snifferList.contains("webservices")) {
                    wsAppMap = AppUtil.getWsEndpointMap(appName, moduleName, snifferList);
                }
                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                attrMap.put("appname", encodedAppName);
                attrMap.put("id", encodedModuleName);
                String prefix = GuiUtil.getSessionValue(REST_URL) + PATH_APPLICATIONS_APPLICATION + encodedAppName;
                Map<String, Object> subMap = RestUtil.restRequest(prefix + "/list-sub-components", attrMap, "GET", null, false);
                Map data = (Map)subMap.get("data");
                if (data != null) {
                    Map props = (Map)data.get("properties");
                    if (props == null) {
                        return result;
                    }
                    for (Map.Entry e : props.entrySet()) {
                        HashMap<String, Object> oneRow = new HashMap<String, Object>();
                        oneRow.put("moduleName", moduleName);
                        oneRow.put("name", e.getKey());
                        oneRow.put("type", e.getValue());
                        oneRow.put("hasLaunch", false);
                        oneRow.put("sniffers", "");
                        oneRow.put("hasEndpoint", false);
                        oneRow.put("hasAppClientLaunch", false);
                        oneRow.put("hasAppClientStub", false);
                        if (wsAppMap != null && AppUtil.getEndpointDetails(wsAppMap, moduleName, (String)e.getKey()) != null) {
                            oneRow.put("hasEndpoint", true);
                        }
                        result.add(oneRow);
                    }
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getSubComponentDetail") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block7;
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static void addToAppScopedResourcesTable(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String moduleName = (String)handlerCtx.getInputValue("moduleName");
        Map resources = (Map)handlerCtx.getInputValue("resources");
        ArrayList result = (ArrayList)handlerCtx.getInputValue("listOfRows");
        if (result == null) {
            result = new ArrayList();
        }
        if (GuiUtil.isEmpty(moduleName)) {
            moduleName = "-----------";
        }
        if (resources != null) {
            for (Map.Entry e : resources.entrySet()) {
                String resource = (String)e.getKey();
                String value = (String)e.getValue();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("appName", appName);
                oneRow.put("moduleName", moduleName);
                oneRow.put("resName", resource);
                oneRow.put("resType", AppUtil.getAppScopedResType(value, "display"));
                String link = AppUtil.getAppScopedResType(value, "edit") + resource + "&appName=" + appName;
                if (!moduleName.equals("-----------")) {
                    link = link + "&moduleName=" + moduleName;
                }
                oneRow.put("link", link);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue(NAME_RESULT, result);
    }

    public static void appScopedResourcesExist(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        try {
            List moduleList = (List)handlerCtx.getInputValue("moduleList");
            handlerCtx.setOutputValue("appScopedResExists", (Object)AppUtil.doesAppContainsResources(appName, moduleList));
        }
        catch (NullPointerException e) {
            handlerCtx.setOutputValue("appScopedResExists", (Object)false);
        }
    }

    public static void getLifecyclesInfo(HandlerContext handlerCtx) {
        List children = (List)handlerCtx.getInputValue("children");
        ArrayList result = new ArrayList();
        String prefix = GuiUtil.getSessionValue(REST_URL) + PATH_APPLICATIONS_APPLICATION;
        if (children == null) {
            handlerCtx.setOutputValue(NAME_RESULT, result);
            return;
        }
        for (Map oneChild : children) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            try {
                String name = (String)oneChild.get("message");
                String encodedName = URLEncoder.encode(name, "UTF-8");
                oneRow.put("name", name);
                oneRow.put("encodedName", encodedName);
                oneRow.put("selected", false);
                oneRow.put("loadOrder", RestUtil.getPropValue(prefix + encodedName, "load-order", handlerCtx));
                oneRow.put("enableURL", DeployUtil.getTargetEnableInfo(name, true, true));
                result.add(oneRow);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getLifecyclesInfo") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) continue;
                ex.printStackTrace();
            }
        }
        handlerCtx.setOutputValue(NAME_RESULT, result);
    }

    public static void deleteLifecycle(HandlerContext handlerCtx) {
        List selectedList = (List)handlerCtx.getInputValue("selectedList");
        String endpoint = GuiUtil.getSessionValue(REST_URL) + "/applications/application/delete-lifecycle-module";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        try {
            for (Map oneRow : selectedList) {
                String name = (String)oneRow.get("name");
                String encodedName = URLEncoder.encode(name, "UTF-8");
                attrs.put("id", encodedName);
                List<Map<String, Object>> appRefs = DeployUtil.getRefEndpoints(name, "application-ref");
                for (Map<String, Object> oneRef : appRefs) {
                    attrs.put("target", oneRef.get("targetName"));
                    RestUtil.restRequest((String)oneRef.get("endpoint"), attrs, "DELETE", null, false);
                }
                attrs.put("target", "domain");
                RestUtil.restRequest(endpoint, attrs, "POST", handlerCtx, false);
            }
        }
        catch (Exception ex) {
            GuiUtil.prepareException(handlerCtx, ex);
        }
    }

    private static void getLaunchInfo(String appName, String contextRoot, Map<String, Object> oneRow) {
        Map entity;
        Map extraProperties;
        String endpoint = GuiUtil.getSessionValue(REST_URL) + PATH_APPLICATIONS_APPLICATION + appName + ".json";
        Map<String, Object> map = RestUtil.restRequest(endpoint, null, "GET", null, false);
        Map data = (Map)map.get("data");
        boolean enabled = false;
        if (data != null && (extraProperties = (Map)data.get("extraProperties")) != null && (entity = (Map)extraProperties.get("entity")) != null) {
            if (contextRoot == null) {
                contextRoot = (String)entity.get("contextRoot");
            }
            enabled = Boolean.parseBoolean((String)entity.get("enabled"));
        }
        oneRow.put("contextRoot", contextRoot == null ? "" : contextRoot);
        oneRow.put("hasLaunch", false);
        if (!enabled || GuiUtil.isEmpty(contextRoot)) {
            return;
        }
        List<String> targetList = DeployUtil.getApplicationTarget(appName, "application-ref");
        for (String target : targetList) {
            String virtualServers = ApplicationHandlers.getVirtualServers(target, appName);
            String ep = TargetUtil.getTargetEndpoint(target) + "/application-ref/" + appName;
            enabled = Boolean.parseBoolean((String)RestUtil.getAttributesMap(ep).get("enabled"));
            if (!enabled || virtualServers == null || virtualServers.length() <= 0) continue;
            oneRow.put("hasLaunch", true);
        }
    }

    private static String getVirtualServers(String target, String appName) {
        List<String> clusters = TargetUtil.getClusters();
        List<String> standalone = TargetUtil.getStandaloneInstances();
        List<String> dgs = TargetUtil.getDeploymentGroups();
        standalone.add("server");
        Object ep = (String)GuiUtil.getSessionValue(REST_URL);
        ep = clusters.contains(target) ? (String)ep + "/clusters/cluster/" + target + "/application-ref/" + appName : (dgs.contains(target) ? (String)ep + "/deployment-groups/deployment-group/" + target + "/application-ref/" + appName : (String)ep + "/servers/server/" + target + "/application-ref/" + appName);
        String virtualServers = (String)RestUtil.getAttributesMap((String)ep).get("virtualServers");
        return virtualServers;
    }

    public static void getTargetEndpoint(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("endpoint", (Object)TargetUtil.getTargetEndpoint((String)handlerCtx.getInputValue("target")));
    }

    public static void getConfigName(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue(NAME_CONFIG_NAME, (Object)TargetUtil.getConfigName((String)handlerCtx.getInputValue("target")));
    }

    public static void getApplicationTarget(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        handlerCtx.setOutputValue(NAME_RESULT, DeployUtil.getApplicationTarget(appName, "application-ref"));
    }

    public static void changeTargetStatus(HandlerContext handlerCtx) {
        String Enabled = (String)handlerCtx.getInputValue("Enabled");
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        boolean forLB = (Boolean)handlerCtx.getInputValue("forLB");
        for (Map oneRow : selectedRows) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("id", oneRow.get("name"));
            attrs.put("target", oneRow.get("targetName"));
            String endpoint = (String)oneRow.get("endpoint");
            if (forLB) {
                attrs.put("lbEnabled", Enabled);
                RestUtil.restRequest(endpoint, attrs, "post", handlerCtx, false);
                continue;
            }
            attrs.put("enabled", Enabled);
            RestUtil.restRequest(endpoint, attrs, "post", handlerCtx, false);
        }
    }

    public static void changeAppRefStatus(HandlerContext handlerCtx) {
        String Enabled = (String)handlerCtx.getInputValue("Enabled");
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        boolean forLB = (Boolean)handlerCtx.getInputValue("forLB");
        for (Map oneRow : selectedRows) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            String endpoint = (String)oneRow.get("endpoint");
            if (forLB) {
                attrs.put("lbEnabled", Enabled);
                RestUtil.restRequest(endpoint, attrs, "post", handlerCtx, false);
                continue;
            }
            attrs.put("enabled", Enabled);
            RestUtil.restRequest(endpoint, attrs, "post", handlerCtx, false);
        }
    }

    public static void changeAppTargets(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String status = (String)handlerCtx.getInputValue("status");
        String[] selTargets = (String[])handlerCtx.getInputValue("targets");
        List<String> selectedTargets = Arrays.asList(selTargets);
        List<String> clusters = TargetUtil.getClusters();
        List<String> standalone = TargetUtil.getStandaloneInstances();
        List<String> dgs = TargetUtil.getDeploymentGroups();
        standalone.add("server");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("id", appName);
        List<String> associatedTargets = DeployUtil.getApplicationTarget(appName, "application-ref");
        for (String newTarget : selectedTargets) {
            if (associatedTargets.contains(newTarget)) {
                associatedTargets.remove(newTarget);
                continue;
            }
            AppUtil.manageAppTarget(appName, newTarget, true, status, clusters, standalone, dgs, handlerCtx);
        }
        for (String oTarget : associatedTargets) {
            AppUtil.manageAppTarget(appName, oTarget, false, null, clusters, standalone, dgs, handlerCtx);
        }
    }

    public static void reloadApplication(HandlerContext handlerCtx) {
        List<String> targets;
        String appName = (String)handlerCtx.getInputValue("appName");
        if (DeployUtil.reloadApplication(appName, targets = DeployUtil.getApplicationTarget(appName, "application-ref"), handlerCtx)) {
            GuiUtil.prepareAlert("success", GuiUtil.getMessage("org.glassfish.web.admingui.Strings", "restart.successPE"), null);
        }
    }

    public static void getTargetEnableInfo(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        Boolean isApp = (Boolean)handlerCtx.getInputValue("isApp");
        if (isApp == null) {
            isApp = true;
        }
        handlerCtx.setOutputValue("status", (Object)DeployUtil.getTargetEnableInfo(appName, false, isApp));
    }

    public static void getVsForDeployment(HandlerContext handlerCtx) {
        String targetConfig = (String)handlerCtx.getInputValue("targetConfig");
        String endpoint = GuiUtil.getSessionValue(REST_URL) + "/configs/config/" + targetConfig + "/http-service/virtual-server";
        ArrayList<Object> vsList = new ArrayList();
        try {
            vsList = new ArrayList<String>(RestUtil.getChildMap(endpoint).keySet());
            vsList.remove("__asadmin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        handlerCtx.setOutputValue(NAME_RESULT, vsList);
    }

    public static void getTargetListInfo(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String prefix = (String)GuiUtil.getSessionValue(REST_URL);
        List<String> clusters = TargetUtil.getClusters();
        List<String> standalone = TargetUtil.getStandaloneInstances();
        List<String> dgs = TargetUtil.getDeploymentGroups();
        standalone.add("server");
        List<String> targetList = DeployUtil.getApplicationTarget(appName, "application-ref");
        ArrayList result = new ArrayList();
        Map<String, Object> attrs = null;
        Object endpoint = "";
        for (String oneTarget : targetList) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            if (clusters.contains(oneTarget)) {
                endpoint = prefix + "/clusters/cluster/" + oneTarget + "/application-ref/" + appName;
                attrs = RestUtil.getAttributesMap((String)endpoint);
            } else if (standalone.contains(oneTarget)) {
                endpoint = prefix + "/servers/server/" + oneTarget + "/application-ref/" + appName;
                attrs = RestUtil.getAttributesMap((String)endpoint);
            } else {
                endpoint = prefix + "/deployment-groups/deployment-group/" + oneTarget + "/application-ref/" + appName;
                attrs = RestUtil.getAttributesMap((String)endpoint);
            }
            oneRow.put("name", appName);
            oneRow.put("selected", false);
            oneRow.put("endpoint", ((String)endpoint).replaceAll("/application-ref/.*", "/update-application-ref"));
            oneRow.put("targetName", oneTarget);
            oneRow.put("enabled", attrs.get("enabled"));
            oneRow.put("lbEnabled", attrs.get("lbEnabled"));
            result.add(oneRow);
        }
        handlerCtx.setOutputValue(NAME_RESULT, result);
    }

    public static void getSingleTargetAppsInfo(HandlerContext handlerCtx) {
        String appRefEndpoint = (String)handlerCtx.getInputValue("appRefEndpoint");
        String target = (String)handlerCtx.getInputValue("target");
        Map appPropsMap = (Map)handlerCtx.getInputValue("appPropsMap");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        TreeSet<String> filters = new TreeSet<String>();
        filters.add("");
        if (GuiUtil.isEmpty(filterValue)) {
            filterValue = null;
        }
        ArrayList result = new ArrayList();
        String prefix = (String)GuiUtil.getSessionValue(REST_URL);
        if (appPropsMap != null) {
            for (Map.Entry e : appPropsMap.entrySet()) {
                try {
                    String engines = (String)e.getValue();
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    oneRow.put("name", e.getKey());
                    String encodedName = URLEncoder.encode((String)e.getKey(), "UTF-8");
                    oneRow.put("targetName", target);
                    oneRow.put("selected", false);
                    String endpoint = prefix + appRefEndpoint + encodedName;
                    oneRow.put("endpoint", endpoint);
                    Map<String, Object> appRefAttrsMap = RestUtil.getAttributesMap(endpoint);
                    String image = appRefAttrsMap.get("enabled").equals("true") ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
                    oneRow.put("enabled", image);
                    image = appRefAttrsMap.get("lbEnabled").equals("true") ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
                    oneRow.put("lbEnabled", image);
                    oneRow.put("sniffers", engines);
                    List<String> sniffersList = GuiUtil.parseStringList(engines, ",");
                    oneRow.put("sniffersList", sniffersList);
                    for (int ix = 0; ix < sniffersList.size(); ++ix) {
                        filters.add(sniffersList.get(ix));
                    }
                    if (filterValue != null && !sniffersList.contains(filterValue)) continue;
                    result.add(oneRow);
                }
                catch (Exception exception) {}
            }
        }
        handlerCtx.setOutputValue(NAME_RESULT, result);
        handlerCtx.setOutputValue("filters", new ArrayList(filters));
    }

    public void getFirstDeploymentUrl(HandlerContext ctx) {
        String appId = (String)ctx.getInputValue("appId");
        List<Map<String, String>> list = this.getTargetURLList(appId, "");
        Map<String, String> firstEntry = list.get(0);
        String url = firstEntry.get("url");
        ctx.setOutputValue("deploymentUrl", (Object)url);
    }

    public void getTargetURLList(HandlerContext handlerCtx) {
        String appID = (String)handlerCtx.getInputValue("AppID");
        String contextRoot = (String)handlerCtx.getInputValue("contextRoot");
        String ctxRoot = ApplicationHandlers.calContextRoot(contextRoot);
        List<Map<String, String>> list = this.getTargetURLList(appID, ctxRoot);
        handlerCtx.setOutputValue("URLList", list);
    }

    private List<Map<String, String>> getTargetURLList(String appId, String contextRoot) {
        TreeSet<String> URLs = new TreeSet<String>();
        List<String> targetList = DeployUtil.getApplicationTarget(appId, "application-ref");
        List<String> dgs = TargetUtil.getDeploymentGroups();
        for (String target : targetList) {
            String ep;
            boolean enabled;
            if (dgs.contains(target) || !(enabled = Boolean.parseBoolean((String)RestUtil.getAttributesMap(ep = TargetUtil.getTargetEndpoint(target) + "/application-ref/" + appId).get("enabled")))) continue;
            String virtualServers = ApplicationHandlers.getVirtualServers(target, appId);
            String configName = TargetUtil.getConfigName(target);
            List<String> clusters = TargetUtil.getClusters();
            List<Object> instances = new ArrayList<String>();
            if (clusters.contains(target)) {
                instances = TargetUtil.getClusteredInstances(target);
            } else {
                instances.add(target);
            }
            for (String string : instances) {
                Collection<String> hostNames = TargetUtil.getHostNames(string);
                URLs.addAll(ApplicationHandlers.getURLs(GuiUtil.parseStringList(virtualServers, ","), configName, hostNames, string));
            }
        }
        Iterator it = URLs.iterator();
        String url = null;
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        while (it.hasNext()) {
            url = (String)it.next();
            String target = "";
            int i = url.indexOf("@@@");
            if (i >= 0) {
                target = url.substring(0, i);
                url = url.substring(i + 3);
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("url", url + contextRoot);
            m.put("target", target);
            list.add(m);
        }
        return list;
    }

    public static void getApplicationType(HandlerContext handlerCtx) {
        Map snifferMap = (Map)handlerCtx.getInputValue("snifferMap");
        String appType = "other";
        if (!GuiUtil.isEmpty((String)snifferMap.get("web"))) {
            appType = "war";
        } else if (!GuiUtil.isEmpty((String)snifferMap.get("ejb"))) {
            appType = "ejb";
        } else if (!GuiUtil.isEmpty((String)snifferMap.get("connector"))) {
            appType = "rar";
        } else if (!GuiUtil.isEmpty((String)snifferMap.get("appclient"))) {
            appType = "appclient";
        }
        handlerCtx.setOutputValue("appType", (Object)appType);
    }

    private static String calContextRoot(String contextRoot) {
        Object ctxRoot = "";
        ctxRoot = contextRoot == null || contextRoot.equals("") || contextRoot.equals("/") ? "/" : (contextRoot.startsWith("/") ? contextRoot : "/" + contextRoot);
        return ctxRoot;
    }

    private static Set<String> getURLs(List<String> vsList, String configName, Collection<String> hostNames, String target) {
        Map<Object, Object> vsInConfig;
        Object ep;
        TreeSet<String> URLs;
        block12: {
            URLs = new TreeSet<String>();
            if (vsList == null || vsList.size() == 0) {
                return URLs;
            }
            if (vsList.contains("server")) {
                vsList.remove("server");
                vsList.add(0, "server");
            }
            ep = (String)GuiUtil.getSessionValue(REST_URL);
            ep = (String)ep + "/configs/config/" + configName + "/http-service/virtual-server";
            vsInConfig = new HashMap();
            try {
                vsInConfig = RestUtil.getChildMap((String)ep);
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getURLs") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block12;
                ex.printStackTrace();
            }
        }
        String localHostName = null;
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String vsName : vsList) {
            String listener;
            Object vs;
            if (vsName.equals("__asadmin") || (vs = vsInConfig.get(vsName)) == null || GuiUtil.isEmpty(listener = (String)RestUtil.getAttributesMap((String)(ep = (String)GuiUtil.getSessionValue(REST_URL) + "/configs/config/" + configName + "/http-service/virtual-server/" + vsName)).get("networkListeners"))) continue;
            List<String> hpList = GuiUtil.parseStringList(listener, ",");
            for (String one : hpList) {
                String port;
                ep = (String)GuiUtil.getSessionValue(REST_URL) + "/configs/config/" + configName + "/network-config/network-listeners/network-listener/" + one;
                Map<String, Object> nlAttributes = RestUtil.getAttributesMap((String)ep);
                if ("false".equals(nlAttributes.get("enabled"))) continue;
                ep = (String)GuiUtil.getSessionValue(REST_URL) + "/configs/config/" + configName + "/network-config/protocols/protocol/" + (String)nlAttributes.get("protocol");
                String security = (String)RestUtil.getAttributesMap((String)ep).get("securityEnabled");
                String protocol = "http";
                if ("true".equals(security)) {
                    protocol = "https";
                }
                if ((port = (String)nlAttributes.get("port")) == null) {
                    port = "";
                }
                String resolvedPort = RestUtil.resolveToken((String)GuiUtil.getSessionValue(REST_URL) + "/servers/server/" + target, port);
                for (String hostName : hostNames) {
                    if (localHostName != null && hostName.equalsIgnoreCase("localhost")) {
                        hostName = localHostName;
                    }
                    URLs.add(target + "@@@" + protocol + "://" + hostName + ":" + resolvedPort);
                }
            }
        }
        return URLs;
    }
}

