/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.ServerDirs;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.api.admin.CommandException;

public class StartServerHelper {
    private final boolean terse;
    private final GFLauncher launcher;
    private final Logger logger;
    private final File pidFile;
    private final GFLauncherInfo info;
    private final List<HostAndPort> addresses;
    private final ServerDirs serverDirs;
    private final String masterPassword;
    private final String serverOrDomainName;
    private final int debugPort;
    private final boolean isDebugSuspend;
    private boolean isWarmup = false;
    private static final boolean DEBUG_MESSAGES_ON = false;
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(StartServerHelper.class);
    private static final String PROPS_PORT_NAME = "_PORT";
    private static final String PROPS_HZ_PORT_NAME = "HZ_LISTENER_PORT";

    public StartServerHelper(Logger logger0, boolean terse0, ServerDirs serverDirs0, GFLauncher launcher0, String masterPassword0) {
        this.logger = logger0;
        this.terse = terse0;
        this.launcher = launcher0;
        this.info = this.launcher.getInfo();
        this.serverOrDomainName = this.info.isDomain() ? this.info.getDomainName() : this.info.getInstanceName();
        this.addresses = this.info.getAdminAddresses();
        this.serverDirs = serverDirs0;
        this.pidFile = this.serverDirs.getPidFile();
        this.masterPassword = masterPassword0;
        this.debugPort = this.launcher.getDebugPort();
        this.isDebugSuspend = this.launcher.isDebugSuspend();
        if (this.isDebugSuspend && this.debugPort >= 0) {
            this.logger.info(STRINGS.get("ServerStart.DebuggerSuspendedMessage", new Object[]{"" + this.debugPort}));
        }
    }

    public void waitForServer() throws CommandException {
        this.waitForServer(600000L, TimeUnit.MILLISECONDS);
    }

    public void waitForServer(long timeout, TimeUnit unit) throws CommandException {
        long startWait = System.currentTimeMillis();
        if (!this.terse) {
            System.out.print(STRINGS.get("WaitServer", new Object[]{this.serverOrDomainName}) + " ");
        }
        boolean alive = false;
        int count = 0;
        block5: while (!StartServerHelper.timedOut(startWait, unit.toMillis(timeout))) {
            if (this.pidFile != null) {
                this.logger.log(Level.FINER, "Check for pid file: {0}", this.pidFile);
                if (this.pidFile.exists()) {
                    alive = true;
                    break;
                }
            } else {
                for (HostAndPort address : this.addresses) {
                    if (!NetUtils.isRunning((String)address.getHost(), (int)address.getPort())) continue;
                    alive = true;
                    break block5;
                }
            }
            try {
                int exitCode = this.launcher.getProcess().exitValue();
                String sname = this.info.isDomain() ? "domain " + this.info.getDomainName() : "instance " + this.info.getInstanceName();
                String output = this.launcher.getProcessStreamDrainer().getOutErrString();
                if (StringUtils.ok((String)output)) {
                    throw new CommandException(STRINGS.get("serverDiedOutput", new Object[]{sname, exitCode, output}));
                }
                throw new CommandException(STRINGS.get("serverDied", new Object[]{sname, exitCode}));
            }
            catch (GFLauncherException exitCode) {
            }
            catch (IllegalThreadStateException exitCode) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
                if (this.terse || count++ % 10 != 0) continue;
                System.out.print(".");
            }
            catch (InterruptedException exitCode) {}
        }
        if (!this.terse) {
            System.out.println();
        }
        if (!alive) {
            String time = "" + unit.toSeconds(timeout);
            String msg = this.info.isDomain() ? STRINGS.get("serverNoStart", new Object[]{STRINGS.get("DAS"), this.info.getDomainName(), time}) : STRINGS.get("serverNoStart", new Object[]{STRINGS.get("INSTANCE"), this.info.getInstanceName(), time});
            throw new CommandException(msg);
        }
    }

    public boolean prepareForLaunch() throws CommandException {
        this.waitForParentToDie();
        this.setSecurity();
        if (!this.checkPorts()) {
            return false;
        }
        this.deletePidFile();
        return true;
    }

    public void report() {
        String logfile;
        try {
            logfile = this.launcher.getLogFilename();
        }
        catch (GFLauncherException ex) {
            logfile = "UNKNOWN";
        }
        int adminPort = -1;
        Object adminPortString = "-1";
        try {
            if (this.addresses != null && !this.addresses.isEmpty()) {
                adminPort = this.addresses.get(0).getPort();
            }
            adminPortString = "" + adminPort;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.info(STRINGS.get("ServerStart.SuccessMessage", new Object[]{this.info.isDomain() ? "domain " : "instance", this.serverDirs.getServerName(), this.serverDirs.getServerDir(), logfile, adminPortString}));
        if (this.debugPort >= 0) {
            this.logger.info(STRINGS.get("ServerStart.DebuggerMessage", new Object[]{"" + this.debugPort}));
        }
        if (this.isWarmup) {
            this.logger.info(STRINGS.get("ServerStart.SuccessWithWarmupEnabled"));
        }
    }

    private void waitForParentToDie() throws CommandException {
        String pids = System.getProperty("AS_RESTART");
        if (!StringUtils.ok((String)pids)) {
            return;
        }
        int pid = -1;
        try {
            pid = Integer.parseInt(pids);
        }
        catch (Exception e) {
            pid = -1;
        }
        this.waitForParentDeath(pid);
    }

    private boolean checkPorts() {
        String err = this.adminPortInUse();
        err = this.validateAdditionalPortsForConnection();
        if (err != null) {
            this.logger.severe(err);
            return false;
        }
        return true;
    }

    private void deletePidFile() {
        String msg = this.serverDirs.deletePidFile();
        if (msg != null && this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(msg);
        }
    }

    private void setSecurity() {
        this.info.addSecurityToken("AS_ADMIN_MASTERPASSWORD", this.masterPassword);
    }

    private String adminPortInUse() {
        return this.adminPortInUse(this.info.getAdminAddresses());
    }

    private String adminPortInUse(List<HostAndPort> adminAddresses) {
        for (HostAndPort addr : adminAddresses) {
            if (NetUtils.isPortFree((String)addr.getHost(), (int)addr.getPort())) continue;
            return STRINGS.get("ServerRunning", new Object[]{Integer.toString(addr.getPort())});
        }
        return null;
    }

    private String validateAdditionalPortsForConnection() {
        List list = this.info.getAdminAddresses();
        String host = null;
        if (list.size() > 0) {
            for (HostAndPort addr : list) {
                host = addr.getHost();
                Map propsFromXMl = this.launcher.getSysPropsFromXml();
                Set setOfPorts = propsFromXMl.entrySet().stream().filter(e -> !((String)e.getKey()).contains(PROPS_HZ_PORT_NAME) && ((String)e.getKey()).contains(PROPS_PORT_NAME)).collect(Collectors.toSet());
                for (Map.Entry e2 : setOfPorts) {
                    if (NetUtils.isPortFree((String)host, (int)Integer.parseInt((String)e2.getValue()))) continue;
                    return String.format("Port %d is in use", Integer.parseInt((String)e2.getValue()));
                }
            }
        }
        return null;
    }

    private void waitForParentDeath(int pid) throws CommandException {
        if (pid < 0) {
            new ParentDeathWaiterPureJava();
            return;
        }
        long start = System.currentTimeMillis();
        try {
            do {
                Boolean b;
                if ((b = ProcessUtils.isProcessRunning((int)pid)) == null) {
                    StartServerHelper.debugMessage("ProcessUtils.isProcessRunning(" + pid + ") returned null which means we can't get process info on this platform.");
                    new ParentDeathWaiterPureJava();
                    return;
                }
                if (!b.booleanValue()) {
                    StartServerHelper.debugMessage("Parent process (" + pid + ") is dead.");
                    return;
                }
                StartServerHelper.debugMessage("Wait one more second for parent to die...");
                Thread.sleep(1000L);
            } while (!StartServerHelper.timedOut(start, 60000L));
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new CommandException(STRINGS.get("deathwait_timeout", new Object[]{60000L}));
    }

    private static boolean timedOut(long startTime) {
        return StartServerHelper.timedOut(startTime, 600000L);
    }

    private static boolean timedOut(long startTime, long span) {
        return System.currentTimeMillis() - startTime > span;
    }

    private static void debugMessage(String s) {
    }

    public void setWarmup(boolean warmup) {
        this.isWarmup = warmup;
    }

    public boolean getWarmup() {
        return this.isWarmup;
    }

    private class ParentDeathWaiterPureJava
    implements Runnable {
        boolean success = false;

        @Override
        public void run() {
            try {
                while (System.in.read() >= 0) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            while (StartServerHelper.this.adminPortInUse(StartServerHelper.this.addresses) != null) {
            }
            this.success = true;
        }

        private ParentDeathWaiterPureJava() throws CommandException {
            try {
                Thread t = new Thread(this);
                t.start();
                t.join(60000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.success) {
                throw new CommandException(STRINGS.get("deathwait_timeout", new Object[]{60000L}));
            }
        }
    }
}

