/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.net.NetUtils;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomainPortValidator {
    private static final Logger LOGGER = SLogger.getLogger();
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(DomainPortValidator.class);
    public static final int PORT_MAX_VAL = 65535;
    private final DomainConfig domainConfig;
    private final Properties defaultProps;

    DomainPortValidator(DomainConfig domainConfig, Properties defaultProps) {
        this.domainConfig = domainConfig;
        this.defaultProps = defaultProps;
    }

    public void validateAndSetPorts() throws DomainException {
        Properties domainProperties = this.domainConfig.getDomainProperties();
        try {
            Integer adminPortInt = this.getPort(domainProperties, "domain.adminPort", (String)this.domainConfig.get("domain.adminPort"), this.defaultProps.getProperty("ADMIN_PORT"), "Admin");
            this.domainConfig.add("domain.adminPort", adminPortInt);
            Integer instancePortInt = this.getPort(domainProperties, "domain.instancePort", (String)this.domainConfig.get("domain.instancePort"), this.defaultProps.getProperty("HTTP_PORT"), "HTTP Instance");
            this.domainConfig.add("domain.instancePort", instancePortInt);
            Integer jmsPort = this.getPort(domainProperties, "jms.port", null, this.defaultProps.getProperty("JMS_PROVIDER_PORT"), "JMS");
            this.domainConfig.add("jms.port", jmsPort);
            domainProperties.setProperty("JMS_PROVIDER_PORT", jmsPort.toString());
            Integer orbPort = this.getPort(domainProperties, "orb.listener.port", null, this.defaultProps.getProperty("ORB_LISTENER_PORT"), "IIOP");
            this.domainConfig.add("orb.listener.port", orbPort);
            Integer httpSSLPort = this.getPort(domainProperties, "http.ssl.port", null, this.defaultProps.getProperty("HTTP_SSL_PORT"), "HTTP_SSL");
            this.domainConfig.add("http.ssl.port", httpSSLPort);
            Integer iiopSSLPort = this.getPort(domainProperties, "orb.ssl.port", null, this.defaultProps.getProperty("ORB_SSL_PORT"), "IIOP_SSL");
            this.domainConfig.add("orb.ssl.port", iiopSSLPort);
            Integer iiopMutualAuthPort = this.getPort(domainProperties, "orb.mutualauth.port", null, this.defaultProps.getProperty("ORB_MUTUALAUTH_PORT"), "IIOP_MUTUALAUTH");
            this.domainConfig.add("orb.mutualauth.port", iiopMutualAuthPort);
            Integer jmxPort = this.getPort(domainProperties, "domain.jmxPort", null, this.defaultProps.getProperty("JMX_SYSTEM_CONNECTOR_PORT"), "JMX_ADMIN");
            this.domainConfig.add("domain.jmxPort", jmxPort);
            Integer osgiShellTelnetPort = this.getPort(domainProperties, "osgi.shell.telnet.port", null, this.defaultProps.getProperty("OSGI_SHELL_TELNET_PORT"), "OSGI_SHELL");
            this.domainConfig.add("osgi.shell.telnet.port", osgiShellTelnetPort);
            Integer javaDebuggerPort = this.getPort(domainProperties, "java.debugger.port", null, this.defaultProps.getProperty("JAVA_DEBUGGER_PORT"), "JAVA_DEBUGGER");
            this.domainConfig.add("java.debugger.port", javaDebuggerPort);
            Integer hazelcastDasPortInt = this.getPort(domainProperties, "hazelcast.das.port", (String)this.domainConfig.get("hazelcast.das.port"), this.defaultProps.getProperty("HAZELCAST_DAS_PORT"), "Hazelcast DAS");
            this.domainConfig.add("hazelcast.das.port", hazelcastDasPortInt);
            Integer hazelcastStartPortInt = this.getPort(domainProperties, "hazelcast.start.port", (String)this.domainConfig.get("hazelcast.start.port"), this.defaultProps.getProperty("HAZELCAST_START_PORT"), "Hazelcast Start");
            this.domainConfig.add("hazelcast.start.port", hazelcastStartPortInt);
            this.checkPortPrivilege(new Integer[]{adminPortInt, instancePortInt, jmsPort, orbPort, httpSSLPort, jmsPort, orbPort, httpSSLPort, iiopSSLPort, iiopMutualAuthPort, jmxPort, osgiShellTelnetPort, javaDebuggerPort, hazelcastDasPortInt, hazelcastStartPortInt});
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
    }

    private Integer getPort(Properties properties, String key, String portStr, String defaultPort, String name) throws DomainException {
        Boolean checkPorts;
        int port = 0;
        boolean portNotSpecified = false;
        boolean invalidPortSpecified = false;
        boolean defaultPortUsed = false;
        if (portStr != null && !portStr.equals("")) {
            port = this.convertPortStr(portStr);
            if (port <= 0 || port > 65535) {
                invalidPortSpecified = true;
            }
        } else if (properties != null) {
            String property = properties.getProperty(key);
            if (property != null && !property.equals("")) {
                port = this.convertPortStr(property);
            } else {
                portNotSpecified = true;
            }
        } else {
            portNotSpecified = true;
        }
        if (portNotSpecified) {
            if (defaultPort == null || defaultPort.trim().isEmpty()) {
                throw new DomainException(STRINGS.get("MissingDefaultPort", new Object[]{key}));
            }
            port = this.convertPortStr(defaultPort);
            defaultPortUsed = true;
        }
        if ((checkPorts = (Boolean)this.domainConfig.get("domain.validatePorts")).booleanValue() && !NetUtils.isPortFree((int)port)) {
            int newport = NetUtils.getFreePort();
            if (portNotSpecified) {
                if (defaultPortUsed) {
                    LOGGER.log(Level.INFO, "NCLS-SRVRMGMT-00014", new Object[]{name, defaultPort, Integer.toString(newport)});
                } else {
                    LOGGER.log(Level.INFO, "NCLS-SRVRMGMT-00015", new Object[]{name, Integer.toString(newport)});
                }
            } else if (invalidPortSpecified) {
                LOGGER.log(Level.INFO, "NCLS-SRVRMGMT-00016", new Object[]{name, Integer.toString(newport)});
            } else {
                LOGGER.log(Level.INFO, "NCLS-SRVRMGMT-00017", new Object[]{name, Integer.toString(port), Integer.toString(newport)});
            }
            port = newport;
        } else if (defaultPortUsed) {
            LOGGER.log(Level.INFO, "NCLS-SRVRMGMT-00018", new Object[]{name, Integer.toString(port)});
        } else {
            LOGGER.log(Level.INFO, "NCLS-SRVRMGMT-00019", new Object[]{name, Integer.toString(port)});
        }
        if (properties != null) {
            properties.remove(key);
        }
        return port;
    }

    private int convertPortStr(String port) throws DomainException {
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new DomainException(STRINGS.get("InvalidPortNumber", new Object[]{port}));
        }
    }

    private void checkPortPrivilege(Integer[] ports) {
        for (Integer port : ports) {
            if (port >= 1024) continue;
            LOGGER.warning(STRINGS.get("PortPrivilege"));
            break;
        }
    }
}

