/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.servermgmt.pe.TimerCallback;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InstanceTimer
implements Runnable {
    private final int timeOutSeconds;
    private final TimerCallback callBack;
    private final int startAfterSeconds;
    private boolean timeOutReached;
    private long startTime;
    private static final Logger LOGGER = Logger.getLogger("com.sun.enterprise.admin.servermgmt.pe");

    public InstanceTimer(int timeOutSeconds, int startAfterSeconds, TimerCallback callBack) {
        this.timeOutSeconds = timeOutSeconds;
        this.startAfterSeconds = startAfterSeconds;
        this.callBack = callBack;
        this.timeOutReached = false;
    }

    @Override
    public void run() {
        this.startTime = System.currentTimeMillis();
        try {
            Thread.sleep((long)this.startAfterSeconds * 1000L);
            while (!this.timeOutReached() && !this.callBack.check()) {
                try {
                    Thread.sleep(1000L);
                    this.computeTimeOut();
                }
                catch (InterruptedException ie) {
                    LOGGER.log(Level.FINER, ie.toString());
                    this.timeOutReached = true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, e.toString());
            this.timeOutReached = true;
        }
    }

    private boolean timeOutReached() {
        return this.timeOutReached;
    }

    private void computeTimeOut() {
        long currentTime = System.currentTimeMillis();
        this.timeOutReached = currentTime - this.startTime >= (long)this.timeOutSeconds * 1000L;
    }
}

