/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.LinuxSystemDService;
import com.sun.enterprise.admin.servermgmt.services.LinuxSystemVService;
import com.sun.enterprise.admin.servermgmt.services.SMFService;
import com.sun.enterprise.admin.servermgmt.services.Service;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.admin.servermgmt.services.WindowsService;
import com.sun.enterprise.util.io.ServerDirs;

public final class ServiceFactory {
    public static final Service getService(ServerDirs dirs, AppserverServiceType type, String systemType) {
        boolean autodetect;
        boolean bl = autodetect = systemType == null;
        if ("systemd".equals(systemType) || autodetect && LinuxSystemDService.apropos()) {
            return new LinuxSystemDService(dirs, type);
        }
        if ("systemv".equals(systemType) || autodetect && LinuxSystemVService.apropos()) {
            return new LinuxSystemVService(dirs, type);
        }
        if ("solaris".equals(systemType) || autodetect && SMFService.apropos()) {
            return new SMFService(dirs, type);
        }
        if ("windows".equals(systemType) || autodetect && WindowsService.apropos()) {
            return new WindowsService(dirs, type);
        }
        throw new NotSupportedOSException(Strings.get("noSuitableServiceImplementation"));
    }

    public static class NotSupportedOSException
    extends RuntimeException {
        public NotSupportedOSException(String message) {
            super(message);
        }
    }
}

