/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.stringsubs.impl.FileSubstitutionHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;

public class LargeFileSubstitutionHandler
extends FileSubstitutionHandler {
    private static final String BACKUP_FILE_PREFIX = ".bkp";
    private static final String TEMP_FILE_PREFIX = ".tmp";
    private File outputFile;

    public LargeFileSubstitutionHandler(File file) throws FileNotFoundException {
        super(file);
    }

    @Override
    public Reader getReader() {
        try {
            this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.inputFile)));
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, STRINGS.get("invalidFileLocation", new Object[]{this.inputFile.getAbsolutePath()}), e);
        }
        return this.reader;
    }

    @Override
    public Writer getWriter() {
        this.outputFile = new File(this.inputFile.getAbsolutePath() + TEMP_FILE_PREFIX);
        try {
            if (!this.outputFile.exists() && !this.outputFile.createNewFile()) {
                throw new IOException();
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.outputFile)));
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, STRINGS.get("failureTempFileCreation", new Object[]{this.outputFile.getAbsolutePath(), e}));
        }
        return this.writer;
    }

    @Override
    public void finish() {
        super.finish();
        String inputFileName = this.inputFile.getName();
        File inputBackUpfile = new File(this.inputFile.getAbsolutePath() + BACKUP_FILE_PREFIX);
        if (this.inputFile.renameTo(inputBackUpfile)) {
            if (this.outputFile.renameTo(new File(this.inputFile.getAbsolutePath()))) {
                if (!inputBackUpfile.delete()) {
                    LOGGER.log(Level.INFO, STRINGS.get("failureInBackUpFileDeletion", new Object[]{inputBackUpfile.getAbsolutePath()}));
                }
            } else {
                LOGGER.log(Level.INFO, STRINGS.get("failureInFileRename", new Object[]{this.outputFile.getAbsolutePath(), inputFileName}));
            }
        } else {
            LOGGER.log(Level.WARNING, STRINGS.get("failureInFileRename", new Object[]{this.inputFile.getAbsolutePath(), inputBackUpfile.getName()}));
        }
    }
}

