/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.servermgmt.cli;

import com.sun.enterprise.admin.servermgmt.KeystoreManager;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="add-pkcs8")
@PerLookup
public class AddKeypairCommand
extends LocalDomainCommand {
    @Param(name="domain_name", optional=true)
    String userArgDomainName;
    @Param(optional=false)
    String destAlias;
    @Param(name="priv-key-path", optional=false)
    String pkcs8PrivateKeyPath;
    @Param(name="cert-chain-path", optional=false)
    String certPath;
    KeystoreManager keyManager = new KeystoreManager();

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.userArgDomainName);
        super.validate();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        File privKeyFile = new File(this.pkcs8PrivateKeyPath);
        try {
            File destKeyStore = this.getKeyStoreFile();
            try (FileInputStream privIn = new FileInputStream(privKeyFile);){
                PrivateKey privKey = this.keyManager.readPlainPKCS8PrivateKey(privIn, "RSA");
                Collection<? extends Certificate> certChain = this.keyManager.readPemCertificateChain(new File(this.certPath));
                String mp = this.getMasterPassword();
                this.keyManager.addKeyPair(destKeyStore, "JKS", mp.toCharArray(), privKey, certChain.toArray(new Certificate[1]), this.destAlias);
                logger.fine(() -> MessageFormat.format("Private key with alias [{0}] added to keystore {1}.", this.destAlias, destKeyStore.getAbsolutePath()));
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException ex) {
                Logger.getLogger(AddKeypairCommand.class.getName()).log(Level.SEVERE, null, ex);
                throw new CommandException(ex.getLocalizedMessage());
            }
        }
        catch (InvalidKeySpecException ex) {
            throw new CommandException(ex.getLocalizedMessage());
        }
        return 0;
    }
}

