/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.servermgmt.cli;

import com.sun.enterprise.admin.servermgmt.cli.RestartDomainCommand;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-domains")
@PerLookup
public class RestartDomainsCommand
extends RestartDomainCommand {
    @Param(name="domain_name", primary=true, optional=true)
    private String userArgDomainName;
    @Param(name="debug", optional=true)
    private Boolean debug;
    @Param(optional=true, defaultValue="600")
    private int timeout;
    @Param(optional=true, defaultValue="600")
    private int domainTimeout;

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        if (this.timeout < 1 || this.domainTimeout < 1) {
            throw new CommandValidationException("Timeout must be at least 1 second long.");
        }
    }

    @Override
    protected int executeCommand() throws CommandException {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        Future<Integer> future = executorService.submit(() -> {
            try {
                String[] domains;
                for (String domainName : domains = this.userArgDomainName.split(",")) {
                    this.setDomainName(domainName);
                    ((RestartDomainCommand)this).timeout = this.domainTimeout;
                    super.executeCommand();
                    logger.log(Level.FINE, "Restarted domain {0}", domainName);
                }
                return 0;
            }
            catch (Exception ex) {
                throw new CommandException(ex.getLocalizedMessage());
            }
        });
        long startTime = System.currentTimeMillis();
        while (!this.timedOut(startTime)) {
            if (!future.isDone()) continue;
            return 0;
        }
        throw new CommandException("Command Timed Out");
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > (long)(this.timeout * 1000);
    }
}

