/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.servermgmt.cli;

import com.sun.enterprise.admin.servermgmt.cli.StartDomainCommand;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="start-domains")
@PerLookup
public class StartDomainsCommand
extends StartDomainCommand {
    @Param(optional=true, defaultValue="false")
    private Boolean upgrade;
    @Param(optional=true, shortName="w", defaultValue="false")
    private Boolean watchdog;
    @Param(optional=true, shortName="d", defaultValue="false")
    private Boolean debug;
    @Param(name="domain_name", primary=true, optional=true)
    private String domainName0;
    @Param(name="dry-run", shortName="n", optional=true, defaultValue="false")
    private Boolean dry_run;
    @Param(name="drop-interrupted-commands", optional=true, defaultValue="false")
    private Boolean drop_interrupted_commands;
    @Param(name="prebootcommandfile", optional=true)
    private String preBootCommand;
    @Param(name="postbootcommandfile", optional=true)
    private String postBootCommand;
    @Param(optional=true, defaultValue="600")
    private int timeout;
    @Param(optional=true, defaultValue="600")
    private int domainTimeout;

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        File postbootFile;
        File prebootfile;
        if (this.preBootCommand != null && !(prebootfile = new File(this.preBootCommand)).exists()) {
            throw new CommandValidationException("preboot commands file does not exist: " + prebootfile.getAbsolutePath());
        }
        if (this.postBootCommand != null && !(postbootFile = new File(this.postBootCommand)).exists()) {
            throw new CommandValidationException("postboot commands file does not exist: " + postbootFile.getAbsolutePath());
        }
        if (this.timeout < 1 || this.domainTimeout < 1) {
            throw new CommandValidationException("Timeout must be at least 1 second long.");
        }
    }

    @Override
    protected int executeCommand() throws CommandException {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        Future<?> future = executorService.submit(() -> {
            try {
                String[] domains;
                for (String domainName : domains = this.domainName0.split(",")) {
                    this.setDomainName(domainName);
                    ((StartDomainCommand)this).timeout = this.domainTimeout;
                    super.initDomain();
                    this.programOpts.setHostAndPort(this.getAdminAddress());
                    super.executeCommand();
                    logger.log(Level.FINE, "Started domain {0}", domainName);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException((Throwable)new CommandException(ex.getLocalizedMessage()));
            }
        });
        long startTime = System.currentTimeMillis();
        while (!this.timedOut(startTime)) {
            if (!future.isDone()) continue;
            return 0;
        }
        throw new CommandException("Command Timed Out");
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > (long)(this.timeout * 1000);
    }
}

