/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.asadmin.recorder.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.asadmin.recorder.AsadminRecorderConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="disable-asadmin-recorder")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="disable.asadmin.recorder")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="disable-asadmin-recorder", description="Disables the asadmin command recorder service")})
public class DisableAsadminRecorder
implements AdminCommand {
    @Inject
    AsadminRecorderConfiguration asadminRecorderConfiguration;

    public void execute(AdminCommandContext context) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AsadminRecorderConfiguration>(){

                public Object run(AsadminRecorderConfiguration asadminRecorderConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                    if (Boolean.parseBoolean(DisableAsadminRecorder.this.asadminRecorderConfiguration.isEnabled())) {
                        asadminRecorderConfigurationProxy.setEnabled(false);
                        Logger.getLogger(DisableAsadminRecorder.class.getName()).log(Level.INFO, "Asadmin Recorder disabled");
                    } else {
                        Logger.getLogger(DisableAsadminRecorder.class.getName()).log(Level.INFO, "Asadmin Recorder already disabled");
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.asadminRecorderConfiguration);
        }
        catch (TransactionFailure ex) {
            Logger.getLogger(DisableAsadminRecorder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

