/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.asadmin.recorder.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.asadmin.recorder.AsadminRecorderConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-asadmin-recorder-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="set.asadmin.recorder.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-asadmin-recorder-configuration", description="Sets the configuration for the asadmin command recorder service")})
public class SetAsadminRecorderConfiguration
implements AdminCommand {
    @Inject
    AsadminRecorderConfiguration asadminRecorderConfiguration;
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    @Param(name="outputLocation", optional=true)
    private String outputLocation;
    @Param(name="filterCommands", optional=true)
    private Boolean filterCommands;
    @Param(name="filteredCommands", optional=true)
    private String filteredCommands;
    @Param(name="prependEnabled", optional=true)
    private Boolean prependEnabled;
    @Param(name="prependedOptions", optional=true)
    private String prependedOptions;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AsadminRecorderConfiguration>(){

                public Object run(AsadminRecorderConfiguration asadminRecorderConfigurationProxy) throws PropertyVetoException {
                    if (SetAsadminRecorderConfiguration.this.enabled != null) {
                        asadminRecorderConfigurationProxy.setEnabled(SetAsadminRecorderConfiguration.this.enabled);
                    }
                    if (SetAsadminRecorderConfiguration.this.filterCommands != null) {
                        asadminRecorderConfigurationProxy.setFilterCommands(SetAsadminRecorderConfiguration.this.filterCommands);
                    }
                    if (SetAsadminRecorderConfiguration.this.outputLocation != null) {
                        if (SetAsadminRecorderConfiguration.this.outputLocation.endsWith("/") || SetAsadminRecorderConfiguration.this.outputLocation.endsWith("\\")) {
                            SetAsadminRecorderConfiguration.this.outputLocation = SetAsadminRecorderConfiguration.this.outputLocation + "asadmin-commands.txt";
                        }
                        if (!SetAsadminRecorderConfiguration.this.outputLocation.endsWith(".txt")) {
                            SetAsadminRecorderConfiguration.this.outputLocation = SetAsadminRecorderConfiguration.this.outputLocation + ".txt";
                        }
                        asadminRecorderConfigurationProxy.setOutputLocation(SetAsadminRecorderConfiguration.this.outputLocation);
                    }
                    if (SetAsadminRecorderConfiguration.this.filteredCommands != null) {
                        asadminRecorderConfigurationProxy.setFilteredCommands(SetAsadminRecorderConfiguration.this.filteredCommands);
                    }
                    if (SetAsadminRecorderConfiguration.this.prependEnabled != null) {
                        asadminRecorderConfigurationProxy.setPrependEnabled(SetAsadminRecorderConfiguration.this.prependEnabled);
                    }
                    String allowedPrependedOptionsRegex = "((H[ =].*)|(host[ =].*)|(p[ =].*)|(port[ =].*)|(U[ =].*)|(user[ =].*)|(W[ =].*)|(passwordfile[ =].*)|(detach)|(notify)|(terse)|(t)|(echo)|(e)|(secure)|(s)|(interactive)|(i))";
                    if (SetAsadminRecorderConfiguration.this.prependedOptions != null) {
                        if (!SetAsadminRecorderConfiguration.this.prependedOptions.isEmpty()) {
                            for (String prependedOption : SetAsadminRecorderConfiguration.this.prependedOptions.split(",")) {
                                if (!prependedOption.matches(allowedPrependedOptionsRegex)) {
                                    throw new PropertyVetoException("Invalid prepended option \"" + prependedOption + "\"", new PropertyChangeEvent(SetAsadminRecorderConfiguration.this.asadminRecorderConfiguration, "prependedOptions", SetAsadminRecorderConfiguration.this.asadminRecorderConfiguration.getPrependedOptions(), prependedOption));
                                }
                                asadminRecorderConfigurationProxy.setPrependedOptions(SetAsadminRecorderConfiguration.this.prependedOptions);
                            }
                        } else {
                            asadminRecorderConfigurationProxy.setPrependedOptions("");
                        }
                    }
                    return null;
                }
            }, (ConfigBeanProxy)this.asadminRecorderConfiguration);
        }
        catch (TransactionFailure ex) {
            actionReport.failure(Logger.getLogger(SetAsadminRecorderConfiguration.class.getName()), "Failed to update configuration due to: " + ex.getLocalizedMessage(), (Throwable)ex);
        }
    }
}

