/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.monitor.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.admin.monitor.cli.Constants;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-monitoring-level")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.monitoring.level")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-monitoring-level", description="List Monitoring Service Level")})
public class GetMonitoringLevel
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Param(name="target", defaultValue="server", optional=true)
    private String target;
    @Param(name="module", optional=true)
    private String moduleName;

    @Override
    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config named: " + this.target);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        MonitoringService monitoringService = config.getMonitoringService();
        ActionReport actionReport = context.getActionReport();
        String[] headers = new String[]{"Module", "Monitoring Level"};
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        ArrayList<String> validModuleList = new ArrayList<String>(Arrays.asList(Constants.validModuleNames));
        if (this.moduleName == null) {
            for (String validModule : validModuleList) {
                columnFormatter.addRow(new Object[]{validModule, monitoringService.getMonitoringLevel(validModule)});
                extraPropertiesMap.put(validModule, monitoringService.getMonitoringLevel(validModule));
            }
        }
        if (this.moduleName != null) {
            List<String> moduleNameList = Arrays.asList(this.moduleName.split(","));
            for (String module : moduleNameList) {
                boolean isValidMoudle = false;
                String selectedModule = module.trim().toLowerCase();
                for (String validModule : validModuleList) {
                    if (!validModule.trim().equals(selectedModule)) continue;
                    columnFormatter.addRow(new Object[]{selectedModule, monitoringService.getMonitoringLevel(selectedModule)});
                    extraPropertiesMap.put(selectedModule, monitoringService.getMonitoringLevel(selectedModule));
                    isValidMoudle = true;
                    break;
                }
                if (isValidMoudle) continue;
                actionReport.setMessage(selectedModule + " isn't a valid Module name");
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        Properties extraProperties = new Properties();
        extraProperties.put("getMonitoringLevel", extraPropertiesMap);
        actionReport.setExtraProperties(extraProperties);
        actionReport.setMessage(columnFormatter.toString());
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

