/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.monitor.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.admin.monitor.cli.Constants;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="restart-monitoring")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.DEPLOYMENT_GROUP, CommandTarget.CONFIG})
public class RestartMonitoring
implements AdminCommand {
    @Param(name="target", optional=true, defaultValue="server-config")
    String target;
    @Param(name="verbose", optional=true, shortName="v", defaultValue="false")
    private Boolean verbose;
    @Inject
    private Target targetUtil;
    @Inject
    private Logger logger;
    private MonitoringService monitoringService;
    private ActionReport actionReport;

    @Override
    public void execute(AdminCommandContext context) {
        this.actionReport = context.getActionReport();
        List<String> validModuleList = Arrays.asList(Constants.validModuleNames);
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            this.actionReport.setMessage("Cound not find target: " + this.target);
            this.actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.monitoringService = config.getMonitoringService();
        Map<String, String> enabledModules = this.getEnabledModules(validModuleList);
        HashMap<String, String> disabledModules = new HashMap<String, String>();
        for (String key : enabledModules.keySet()) {
            disabledModules.put(key, "OFF");
        }
        this.setModules(disabledModules);
        this.setModules(enabledModules);
        ActionReport.ExitCode exitCode = this.actionReport.getActionExitCode();
        this.actionReport.getActionExitCode();
        if (exitCode.equals((Object)ActionReport.ExitCode.WARNING)) {
            this.actionReport.appendMessage("Restarted monitoring levels with warnings");
        }
        if (this.verbose.booleanValue()) {
            this.actionReport.setMessage(this.getFormattedColumns(enabledModules).toString());
        } else {
            this.actionReport.setMessage("Restarted " + enabledModules.size() + " modules");
        }
    }

    private void setModules(Map<String, String> modules) {
        for (Map.Entry<String, String> entry : modules.entrySet()) {
            String module = entry.getKey();
            String moduleLevel = entry.getValue();
            try {
                ConfigSupport.apply(monitoringServiceProxy -> {
                    monitoringServiceProxy.setMonitoringLevel(module, moduleLevel);
                    return monitoringServiceProxy;
                }, (ConfigBeanProxy)this.monitoringService);
            }
            catch (TransactionFailure ex) {
                this.logger.log(Level.WARNING, "Failed to execute the command restart-monitoring, while changing the module level: {0}", ex.getCause().getMessage());
                this.actionReport.setMessage(ex.getCause().getMessage());
                this.actionReport.setActionExitCode(ActionReport.ExitCode.WARNING);
            }
        }
    }

    private Map<String, String> getEnabledModules(List<String> validModules) {
        HashMap<String, String> enabledModules = new HashMap<String, String>();
        for (String module : validModules) {
            String level = this.monitoringService.getMonitoringLevel(module);
            if ("OFF".equals(level)) continue;
            enabledModules.put(module, level);
        }
        return enabledModules;
    }

    private ColumnFormatter getFormattedColumns(Map<String, String> enabledModules) {
        String[] headers = new String[]{"Module", "Monitoring Level"};
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        HashMap<String, String> extraPropertiesMap = new HashMap<String, String>();
        if (!enabledModules.isEmpty()) {
            for (String module : enabledModules.keySet()) {
                columnFormatter.addRow(new Object[]{module, this.monitoringService.getMonitoringLevel(module)});
                extraPropertiesMap.put(module, this.monitoringService.getMonitoringLevel(module));
            }
        }
        return columnFormatter;
    }
}

