/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.ThreadInfo;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="threadinfo-mon", group="monitoring")
@ManagedObject
@Description(value="JVM Thread Info Statistics")
public class JVMThreadInfoStatsProvider {
    private final ThreadInfo threadInfo;
    private final CountStatisticImpl blockedCount = new CountStatisticImpl("BlockedCount", "count", "Returns the total number of times that the thread associated with this ThreadInfo blocked to enter or reenter a monitor");
    private final CountStatisticImpl blockedTime = new CountStatisticImpl("BlockedTime", "millisecond", "Returns the approximate accumulated elapsed time (in milliseconds) that the thread associated with this ThreadInfo has blocked to enter or reenter a monitor since thread contention monitoring is enabled");
    private final StringStatisticImpl lockName = new StringStatisticImpl("LockName", "String", "Returns the string representation of an object for which the thread associated with this ThreadInfo is blocked waiting");
    private final CountStatisticImpl lockOwnerId = new CountStatisticImpl("LockOwnerId", "String", "Returns the ID of the thread which owns the object for which the thread associated with this ThreadInfo is blocked waiting");
    private final StringStatisticImpl lockOwnerName = new StringStatisticImpl("LockOwnerName", "String", "Returns the name of the thread which owns the object for which the thread associated with this ThreadInfo is blocked waiting");
    private final StringStatisticImpl stackTrace = new StringStatisticImpl("StackTrace", "String", "Returns the stack trace of the thread associated with this ThreadInfo");
    private final CountStatisticImpl threadId = new CountStatisticImpl("ThreadId", "String", "Returns the ID of the thread associated with this ThreadInfo");
    private final StringStatisticImpl threadName = new StringStatisticImpl("ThreadName", "String", "Returns the name of the thread associated with this ThreadInfo");
    private final StringStatisticImpl threadState = new StringStatisticImpl("ThreadState", "String", "Returns the state of the thread associated with this ThreadInfo");
    private final CountStatisticImpl waitedCount = new CountStatisticImpl("WaitingCount", "count", "Returns the total number of times that the thread associated with this ThreadInfo waited for notification");
    private final CountStatisticImpl waitedTime = new CountStatisticImpl("WaitingTime", "millisecond", "Returns the approximate accumulated elapsed time (in milliseconds) that the thread associated with this ThreadInfo has waited for notification since thread contention monitoring is enabled");

    public JVMThreadInfoStatsProvider(ThreadInfo info) {
        this.threadInfo = info;
    }

    @ManagedAttribute(id="blockedcount")
    @Description(value="Returns the total number of times that the thread associated with this ThreadInfo blocked to enter or reenter a monitor")
    public CountStatistic getBlockedCount() {
        this.blockedCount.setCount(this.threadInfo.getBlockedCount());
        return this.blockedCount;
    }

    @ManagedAttribute(id="blockedtime")
    @Description(value="Returns the approximate accumulated elapsed time (in milliseconds) that the thread associated with this ThreadInfo has blocked to enter or reenter a monitor since thread contention monitoring is enabled")
    public CountStatistic getBlockedTime() {
        this.blockedTime.setCount(this.threadInfo.getBlockedTime());
        return this.blockedTime;
    }

    @ManagedAttribute(id="lockname")
    @Description(value="Returns the string representation of an object for which the thread associated with this ThreadInfo is blocked waiting")
    public StringStatistic getLockName() {
        String name = this.threadInfo.getLockName();
        if (name == null) {
            this.lockName.setCurrent("Thread is not waiting on monitor lock.");
        } else {
            this.lockName.setCurrent(name);
        }
        return this.lockName;
    }

    @ManagedAttribute(id="lockownerid")
    @Description(value="Returns the ID of the thread which owns the object for which the thread associated with this ThreadInfo is blocked waiting")
    public CountStatistic getLockOwnerId() {
        this.lockOwnerId.setCount(this.threadInfo.getLockOwnerId());
        return this.lockOwnerId;
    }

    @ManagedAttribute(id="lockownername")
    @Description(value="Returns the name of the thread which owns the object for which the thread associated with this ThreadInfo is blocked waiting")
    public StringStatistic getLockOwnerName() {
        String name = this.threadInfo.getLockOwnerName();
        if (name == null) {
            this.lockOwnerName.setCurrent("None of the other threads is holding any monitors of this thread.");
        } else {
            this.lockOwnerName.setCurrent(name);
        }
        return this.lockOwnerName;
    }

    @ManagedAttribute(id="stacktrace")
    @Description(value="Returns the stack trace of the thread associated with this ThreadInfo")
    public StringStatistic getStackTrace() {
        StackTraceElement[] elements = this.threadInfo.getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : elements) {
            sb.append(ste.toString());
            sb.append(',');
        }
        this.stackTrace.setCurrent(sb.toString());
        return this.stackTrace;
    }

    @ManagedAttribute(id="threadid")
    @Description(value="Returns the ID of the thread associated with this ThreadInfo")
    public CountStatistic getThreadId() {
        this.threadId.setCount(this.threadInfo.getThreadId());
        return this.threadId;
    }

    @ManagedAttribute(id="threadname")
    @Description(value="Returns the name of the thread associated with this ThreadInfo")
    public StringStatistic getThreadName() {
        this.threadName.setCurrent(this.threadInfo.getThreadName());
        return this.threadName;
    }

    @ManagedAttribute(id="threadstate")
    @Description(value="Returns the state of the thread associated with this ThreadInfo")
    public StringStatistic getThreadState() {
        this.threadState.setCurrent(this.threadInfo.getThreadState().toString());
        return this.threadState;
    }

    @ManagedAttribute(id="waitedcount")
    @Description(value="Returns the total number of times that the thread associated with this ThreadInfo waited for notification")
    public CountStatistic getWaitedCount() {
        this.waitedCount.setCount(this.threadInfo.getWaitedCount());
        return this.waitedCount;
    }

    @ManagedAttribute(id="waitedtime")
    @Description(value="Returns the approximate accumulated elapsed time (in milliseconds) that the thread associated with this ThreadInfo has waited for notification since thread contention monitoring is enabled")
    public CountStatistic getWaitedTime() {
        this.waitedTime.setCount(this.threadInfo.getWaitedTime());
        return this.waitedTime;
    }
}

