/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.pool.ConnectionPool;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceState {
    private boolean enlisted;
    private boolean busy;
    private long timestamp;
    private TwiceBusyException busyException;
    private Logger LOGGER = LogDomains.getLogger(ConnectionPool.class, (String)"javax.enterprise.resource.resourceadapter");

    public boolean isEnlisted() {
        return this.enlisted;
    }

    public boolean isUnenlisted() {
        return !this.enlisted;
    }

    public boolean isFree() {
        return !this.busy;
    }

    public void setEnlisted(boolean enlisted) {
        this.enlisted = enlisted;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
        if (!busy && this.LOGGER.isLoggable(Level.FINE)) {
            this.busyException = new TwiceBusyException();
        }
    }

    public TwiceBusyException getBusyStackException() {
        return this.busyException;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void touchTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    public ResourceState() {
        this.touchTimestamp();
    }

    public String toString() {
        return "Enlisted :" + this.enlisted + " Busy :" + this.busy;
    }

    public class TwiceBusyException
    extends Exception {
    }
}

