/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.audit;

import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.BaseAuditModule;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class BaseAuditManager<T extends BaseAuditModule>
implements AuditManager {
    static final String NAME = "name";
    static final String CLASSNAME = "classname";
    protected List<T> typedModules = Collections.synchronizedList(new ArrayList());
    private Class<T> typedModuleClass = null;
    private static final Logger LOGGER = SecurityLoggerInfo.getLogger();
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(BaseAuditManager.class);
    private List<BaseAuditModule> instances = Collections.synchronizedList(new ArrayList());
    private final Map<BaseAuditModule, String> moduleToNameMap = new HashMap<BaseAuditModule, String>();
    private final Map<String, BaseAuditModule> nameToModuleMap = new HashMap<String, BaseAuditModule>();
    protected boolean auditOn = false;
    @Inject
    private ServerContext serverContext;
    private static final String AUDIT_MGR_SERVER_STARTUP_KEY = "auditmgr.serverStartup";
    private static final String AUDIT_MGR_SERVER_SHUTDOWN_KEY = "auditmgr.serverShutdown";

    @Override
    public void loadAuditModules() {
        try {
            SecurityService securityBean = (SecurityService)this.serverContext.getDefaultServices().getService(SecurityService.class, "default-instance-name", new Annotation[0]);
            assert (securityBean != null);
            boolean auditFlag = Boolean.parseBoolean(securityBean.getAuditEnabled());
            this.setAuditOn(auditFlag);
            List am = securityBean.getAuditModule();
            for (AuditModule it : am) {
                try {
                    String name = it.getName();
                    String classname = it.getClassname();
                    Properties p = new Properties();
                    p.setProperty(NAME, name);
                    p.setProperty(CLASSNAME, classname);
                    List ep = it.getProperty();
                    for (Property prop : ep) {
                        p.setProperty(prop.getName(), prop.getValue());
                    }
                    BaseAuditModule auditModule = this.loadAuditModule(classname, p);
                    this.instances.add(auditModule);
                    this.moduleToNameMap.put(auditModule, name);
                    this.nameToModuleMap.put(name, auditModule);
                    if (!this.isAuditModuleOfParameterizedType(auditModule)) continue;
                    this.typedModules.add(auditModule);
                }
                catch (Exception ex) {
                    String msg = _localStrings.getLocalString("auditmgr.loaderror", "Audit: Cannot load AuditModule = {0}", new Object[]{it.getName()});
                    LOGGER.log(Level.WARNING, msg, ex);
                }
            }
        }
        catch (Exception e) {
            String msg = _localStrings.getLocalString("auditmgr.badinit", "Audit: Cannot load Audit Module Initialization information. AuditModules will not be loaded.");
            LOGGER.log(Level.WARNING, msg, e);
        }
    }

    public BaseAuditModule addAuditModule(String name, String classname, Properties props) throws Exception {
        this.removeAuditModule(name);
        BaseAuditModule am = this.loadAuditModule(classname, props);
        this.moduleToNameMap.put(am, name);
        this.nameToModuleMap.put(name, am);
        this.instances = this.copyAndAdd(this.instances, am);
        if (this.isAuditModuleOfParameterizedType(am)) {
            this.typedModules = this.copyAndAdd(this.typedModules, am);
        }
        return am;
    }

    private boolean isAuditModuleOfParameterizedType(BaseAuditModule am) {
        return this.typedModuleClass != null && this.typedModuleClass.isAssignableFrom(am.getClass());
    }

    private <U extends BaseAuditModule> List<U> copyAndAdd(List<U> orig, U am) {
        ArrayList<U> list = new ArrayList<U>();
        Collections.copy(orig, list);
        list.add(am);
        return list;
    }

    private <U extends BaseAuditModule> List<U> copyAndRemove(List<U> orig, U am) {
        ArrayList list = new ArrayList();
        Collections.copy(orig, list);
        list.remove(am);
        return list;
    }

    public BaseAuditModule removeAuditModule(String name) {
        BaseAuditModule am = this.nameToModuleMap.get(name);
        if (am != null) {
            this.nameToModuleMap.remove(name);
            this.moduleToNameMap.remove(am);
            this.instances = this.copyAndRemove(this.instances, am);
            if (this.isAuditModuleOfParameterizedType(am)) {
                this.typedModules = this.copyAndRemove(this.typedModules, am);
            }
        }
        return am;
    }

    BaseAuditModule getAuditModule(String name) {
        return this.nameToModuleMap.get(name);
    }

    private BaseAuditModule loadAuditModule(String classname, Properties props) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> am = Class.forName(classname, true, loader);
        Object obj = am.newInstance();
        BaseAuditModule auditModule = (BaseAuditModule)obj;
        auditModule.init(props);
        return auditModule;
    }

    public LocalStringManagerImpl getLocalStrings() {
        return _localStrings;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public void authentication(String user, String realm, boolean success) {
        if (this.auditOn) {
            for (BaseAuditModule am : this.instances) {
                try {
                    am.authentication(user, realm, success);
                }
                catch (Exception ex) {
                    String name = this.moduleName(am);
                    String msg = _localStrings.getLocalString("auditmgr.authentication", " Audit Module {0} threw the following exception during authentication:", new Object[]{name});
                    LOGGER.log(Level.INFO, msg, ex);
                }
            }
        }
    }

    @Override
    public void serverStarted() {
        if (this.auditOn) {
            for (BaseAuditModule am : this.instances) {
                try {
                    am.serverStarted();
                }
                catch (Exception ex) {
                    String name = this.moduleName(am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_SERVER_STARTUP_KEY, " Audit Module {0} threw the following exception during server startup :", new Object[]{name});
                    LOGGER.log(Level.INFO, msg, ex);
                }
            }
        }
    }

    @Override
    public void serverShutdown() {
        if (this.auditOn) {
            for (BaseAuditModule am : this.instances) {
                try {
                    am.serverShutdown();
                }
                catch (Exception ex) {
                    String name = this.moduleName(am);
                    String msg = _localStrings.getLocalString(AUDIT_MGR_SERVER_SHUTDOWN_KEY, " Audit Module {0} threw the following exception during server shutdown :", new Object[]{name});
                    LOGGER.log(Level.INFO, msg, ex);
                }
            }
        }
    }

    public void setAuditOn(boolean auditOn) {
        this.auditOn = auditOn;
    }

    @Override
    public boolean isAuditOn() {
        return this.auditOn;
    }

    protected String moduleName(BaseAuditModule am) {
        return this.moduleToNameMap.get(am);
    }

    protected List<T> instances(Class<T> c) {
        ArrayList<BaseAuditModule> result = new ArrayList<BaseAuditModule>();
        for (BaseAuditModule am : this.instances) {
            if (!c.isAssignableFrom(c)) continue;
            result.add(am);
        }
        return result;
    }
}

