/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.loader.CurrentBeforeParentClassLoader;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.realm.AbstractStatefulRealm;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.RealmStatsProvider;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.RealmsManagerStore;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Contract;

@Contract
public abstract class Realm
extends AbstractStatefulRealm
implements Comparable<Realm> {
    public static final String JAAS_CONTEXT_PARAM = "jaas-context";
    protected static final Logger _logger = SecurityLoggerInfo.getLogger();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Realm.class);
    private static RealmStatsProvider realmStatsProvier;
    public static final String RI_DEFAULT = "default";

    public static synchronized Realm instantiate(String name, String className, Properties props) throws BadRealmException {
        Realm.registerRealmStatsProvier();
        Realm realmClass = Realm._getInstance(name);
        if (realmClass == null) {
            realmClass = Realm.doInstantiate(name, className, props);
            RealmsManagerStore.getRealmsManager().putIntoLoadedRealms(name, realmClass);
        }
        return realmClass;
    }

    public static synchronized Realm instantiate(String name, String className, Properties props, String configName) throws BadRealmException {
        Realm.registerRealmStatsProvier();
        Realm realmClass = Realm._getInstance(configName, name);
        if (realmClass == null) {
            realmClass = Realm.doInstantiate(name, className, props);
            RealmsManagerStore.getRealmsManager().putIntoLoadedRealms(configName, name, realmClass);
        }
        return realmClass;
    }

    public static synchronized Realm getDefaultInstance() throws NoSuchRealmException {
        return Realm.getInstance(Realm.getDefaultRealm());
    }

    public static synchronized String getDefaultRealm() {
        return RealmsManagerStore.tryGetRealmsManager().getDefaultRealmName();
    }

    public static synchronized void setDefaultRealm(String realmName) {
        RealmsManagerStore.tryGetRealmsManager().setDefaultRealmName(realmName);
    }

    public static synchronized Realm getInstance(String name) throws NoSuchRealmException {
        Realm realmInstance = Realm._getInstance(name);
        if (realmInstance == null) {
            throw new NoSuchRealmException(localStrings.getLocalString("realm.no_such_realm", name + " realm does not exist.", new Object[]{name}));
        }
        return realmInstance;
    }

    public static synchronized Realm getInstance(String configName, String name) throws NoSuchRealmException {
        Realm realmInstance = Realm._getInstance(configName, name);
        if (realmInstance == null) {
            throw new NoSuchRealmException(localStrings.getLocalString("realm.no_such_realm", name + " realm does not exist.", new Object[]{name}));
        }
        return realmInstance;
    }

    public static synchronized Enumeration<String> getRealmNames() {
        return RealmsManagerStore.tryGetRealmsManager().getRealmNames();
    }

    public static boolean isValidRealm(String name) {
        return RealmsManagerStore.tryGetRealmsManager().isValidRealm(name);
    }

    public static boolean isValidRealm(String configName, String name) {
        return RealmsManagerStore.tryGetRealmsManager().isValidRealm(configName, name);
    }

    public static synchronized void getRealmStatsProvier() {
        if (realmStatsProvier == null) {
            realmStatsProvier = new RealmStatsProvider();
        }
    }

    public static synchronized void unloadInstance(String realmName) throws NoSuchRealmException {
        Realm.getInstance(realmName);
        RealmsManagerStore.tryGetRealmsManager().removeFromLoadedRealms(realmName);
        _logger.log(Level.INFO, "NCLS-SECURITY-01119", realmName);
    }

    public static synchronized void unloadInstance(String configName, String realmName) throws NoSuchRealmException {
        RealmsManagerStore.tryGetRealmsManager().removeFromLoadedRealms(configName, realmName);
        _logger.log(Level.INFO, "NCLS-SECURITY-01119", realmName);
    }

    protected static synchronized void updateInstance(Realm realm, String name) {
        RealmsManager realmsManager = RealmsManagerStore.tryGetRealmsManager();
        Realm oldRealm = realmsManager.getFromLoadedRealms(name);
        if (!oldRealm.getClass().equals(realm.getClass())) {
            throw new Error("Incompatible class " + realm.getClass() + " in replacement realm " + name);
        }
        realm.setName(oldRealm.getName());
        realmsManager.putIntoLoadedRealms(name, realm);
        _logger.log(Level.FINER, "NCLS-SECURITY-01117", new Object[]{realm.getName()});
    }

    protected static synchronized void updateInstance(String configName, Realm realm, String name) {
        RealmsManager realmsManager = RealmsManagerStore.tryGetRealmsManager();
        Realm oldRealm = realmsManager.getFromLoadedRealms(configName, name);
        if (!oldRealm.getClass().equals(realm.getClass())) {
            throw new Error("Incompatible class " + realm.getClass() + " in replacement realm " + name);
        }
        realm.setName(oldRealm.getName());
        realmsManager.putIntoLoadedRealms(configName, name, realm);
        _logger.log(Level.FINER, "NCLS-SECURITY-01117", new Object[]{realm.getName()});
    }

    private static synchronized Realm doInstantiate(String name, String className, Properties props) throws BadRealmException {
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        try {
            RealmsManager realmsManager = RealmsManagerStore.getRealmsManager();
            Realm realm = (Realm)serviceLocator.getService(Realm.class, name, new Annotation[0]);
            if (realm == null) {
                try {
                    CurrentBeforeParentClassLoader commonClassLoader = ((ClassLoaderHierarchy)serviceLocator.getService(ClassLoaderHierarchy.class, new Annotation[0])).getCommonClassLoader();
                    String realmJarPath = props.getProperty("realmJarPath");
                    if (realmJarPath != null) {
                        commonClassLoader.addURL(Paths.get(realmJarPath, new String[0]).toUri().toURL());
                    }
                    realm = (Realm)commonClassLoader.loadClass(className).newInstance();
                }
                catch (ClassNotFoundException | MalformedURLException ex) {
                    realm = (Realm)Class.forName(className).newInstance();
                }
            }
            realm.setName(name);
            realm.init(props);
            if (realmsManager == null) {
                throw new BadRealmException("Unable to locate RealmsManager Service");
            }
            _logger.log(Level.FINER, "NCLS-SECURITY-01115", new Object[]{name, className});
            return realm;
        }
        catch (NoSuchRealmException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new BadRealmException(ex);
        }
    }

    private static synchronized Realm _getInstance(String name) {
        return RealmsManagerStore.tryGetRealmsManager().getInstance(name);
    }

    private static synchronized Realm _getInstance(String configName, String name) {
        return RealmsManagerStore.tryGetRealmsManager().getInstance(configName, name);
    }

    private static void registerRealmStatsProvier() {
        if (realmStatsProvier == null) {
            Realm.getRealmStatsProvier();
            StatsProviderManager.register((String)"security", (PluginPoint)PluginPoint.SERVER, (String)"security/realm", (Object)realmStatsProvier);
        }
    }
}

