/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmConfig;
import com.sun.enterprise.security.auth.realm.RealmsProbeProvider;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class RealmsManager {
    private static final Logger LOGGER = SecurityLoggerInfo.getLogger();
    private static final String DEFAULT_DIGEST_ALGORITHM = "default-digest-algorithm";
    private volatile String defaultRealmName = "default";
    private final Map<String, Map<String, Realm>> loadedRealms = Collections.synchronizedMap(new HashMap());
    private String defaultDigestAlgorithm;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    private final RealmsProbeProvider probeProvider = new RealmsProbeProvider();

    public synchronized String getDefaultRealmName() {
        return this.defaultRealmName;
    }

    public synchronized void setDefaultRealmName(String defaultRealmName) {
        this.defaultRealmName = defaultRealmName;
    }

    public void createRealms() {
        this.createRealms(this.config.getSecurityService(), this.config);
    }

    public void createRealms(Config config) {
        if (config == null) {
            return;
        }
        this.createRealms(config.getSecurityService(), config);
    }

    public String getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }

    public boolean isValidRealm(String name) {
        if (name == null) {
            return false;
        }
        return this.configContainsRealm(name, this.config.getName());
    }

    public boolean isValidRealm(String configName, String name) {
        if (name == null) {
            return false;
        }
        return this.configContainsRealm(name, configName);
    }

    public Enumeration<String> getRealmNames() {
        return Collections.enumeration(this.getRealmNames(this.config.getName()));
    }

    public Realm getFromLoadedRealms(String realmName) {
        return this.configGetRealmInstance(this.config.getName(), realmName);
    }

    public Realm getFromLoadedRealms(String configName, String realmName) {
        return this.configGetRealmInstance(configName, realmName);
    }

    public List<String> getPredefinedAuthRealmClassNames() {
        return Globals.getDefaultHabitat().getDescriptors((Filter)BuilderHelper.createContractFilter((String)Realm.class.getName())).stream().map(e -> e.getImplementation()).collect(Collectors.toList());
    }

    public void putIntoLoadedRealms(String configName, String realmName, Realm realm) {
        Map<String, Realm> containedRealms = this.loadedRealms.get(configName);
        if (containedRealms == null) {
            containedRealms = new ConcurrentHashMap<String, Realm>();
            if (configName == null) {
                configName = this.config.getName();
            }
            this.loadedRealms.put(configName, containedRealms);
        }
        containedRealms.put(realmName, realm);
    }

    public void refreshRealm(String configName, String realmName) {
        if (realmName != null && !realmName.isEmpty()) {
            try {
                Realm realm = Realm.getInstance(configName, realmName);
                if (realm != null) {
                    realm.refresh(configName);
                }
            }
            catch (BadRealmException | NoSuchRealmException exception) {
                // empty catch block
            }
        }
    }

    public void removeFromLoadedRealms(String realmName) {
        Realm realm = this.removeFromLoadedRealms(this.config.getName(), realmName);
        if (realm != null) {
            this.probeProvider.realmRemovedEvent(realmName);
        }
    }

    public Realm removeFromLoadedRealms(String configName, String realmName) {
        Map<String, Realm> containedRealms = this.loadedRealms.get(configName);
        if (containedRealms == null) {
            return null;
        }
        return containedRealms.remove(realmName);
    }

    Realm getInstance(String name) {
        return this.getInstance(this.config.getName(), name);
    }

    Realm getInstance(String configName, String name) {
        Realm retval = this.configGetRealmInstance(configName, name);
        if (retval == null && "default".equals(name)) {
            retval = this.configGetRealmInstance(configName, this.getDefaultRealmName());
        }
        return retval;
    }

    void putIntoLoadedRealms(String realmName, Realm realm) {
        this.putIntoLoadedRealms(this.config.getName(), realmName, realm);
        this.probeProvider.realmAddedEvent(realmName);
    }

    private void createRealms(SecurityService securityBean, Config cfg) {
        if (this.realmsAlreadyLoaded(cfg.getName())) {
            return;
        }
        this.setDefaultDigestAlgorithm();
        try {
            LOGGER.fine("Initializing configured realms from SecurityService in Domain.xml....");
            if (securityBean == null) {
                securityBean = cfg.getSecurityService();
                assert (securityBean != null);
            }
            String defaultRealm = securityBean.getDefaultRealm();
            List realms = securityBean.getAuthRealm();
            assert (realms != null);
            RealmConfig.createRealms(defaultRealm, realms, cfg.getName());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "NCLS-SECURITY-01101", e);
        }
    }

    private void setDefaultDigestAlgorithm() {
        SecurityService service = this.config.getSecurityService();
        if (service == null) {
            return;
        }
        List props = service.getProperty();
        if (props == null) {
            return;
        }
        Iterator propsIterator = props.iterator();
        while (propsIterator != null && propsIterator.hasNext()) {
            Property prop = (Property)propsIterator.next();
            if (prop == null || !DEFAULT_DIGEST_ALGORITHM.equals(prop.getName())) continue;
            this.defaultDigestAlgorithm = prop.getValue();
            break;
        }
    }

    private boolean realmsAlreadyLoaded(String cfgName) {
        Set<String> realmNames = this.getRealmNames(cfgName);
        return realmNames != null && !realmNames.isEmpty();
    }

    private boolean configContainsRealm(String name, String configName) {
        Map<String, Realm> containedRealms = this.loadedRealms.get(configName);
        return containedRealms != null && containedRealms.containsKey(name);
    }

    private Set<String> getRealmNames(String configName) {
        Map<String, Realm> containedRealms = this.loadedRealms.get(configName);
        if (containedRealms == null) {
            return null;
        }
        return containedRealms.keySet();
    }

    private Realm configGetRealmInstance(String configName, String realm) {
        Map<String, Realm> containedRealms = this.loadedRealms.get(configName);
        if (containedRealms == null) {
            return null;
        }
        return containedRealms.get(realm);
    }
}

