/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.certificate;

import com.sun.enterprise.security.BaseRealm;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.certificate.ClientCertificateExpiryValidator;
import com.sun.enterprise.security.auth.realm.certificate.OID;
import com.sun.enterprise.util.Utility;
import fish.payara.security.client.ClientCertificateValidator;
import java.lang.ref.WeakReference;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterators;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.x500.X500Principal;
import org.glassfish.security.common.Group;
import org.jvnet.hk2.annotations.Service;

@Service
public final class CertificateRealm
extends BaseRealm {
    private static final String COMMON_NAME_AS_PRINCIPAL_NAME = "common-name-as-principal-name";
    private static final String DN_PARTS_USED_FOR_GROUPS = "dn-parts-used-for-groups";
    private static final String VALIDATION_CHECK_PROP = "certificate-validation";
    public static final String AUTH_TYPE = "certificate";
    private final Map<ClassLoader, WeakReference<ServiceLoader<ClientCertificateValidator>>> clientCertificateValidatorMap = Collections.synchronizedMap(new WeakHashMap());

    @Override
    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String validationCheck = props.getProperty(VALIDATION_CHECK_PROP);
        this.setProperty(VALIDATION_CHECK_PROP, validationCheck);
        String jaasCtx = props.getProperty("jaas-context");
        this.setProperty("jaas-context", jaasCtx);
        String useCommonName = props.getProperty(COMMON_NAME_AS_PRINCIPAL_NAME);
        this.setProperty(COMMON_NAME_AS_PRINCIPAL_NAME, useCommonName);
        String dnPartsForGroup = props.getProperty(DN_PARTS_USED_FOR_GROUPS);
        this.setProperty(DN_PARTS_USED_FOR_GROUPS, dnPartsForGroup);
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    @Override
    public Enumeration<String> getGroupNames(String username) {
        String[] groups = this.addAssignGroups(null);
        if (groups == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(Arrays.asList(groups));
    }

    public String authenticate(Subject subject, X500Principal principal) {
        this.validateSubjectViaAPI(subject, principal);
        _logger.finest(() -> String.format("authenticate(subject=%s, principal=%s)", subject, principal));
        LdapName dn = this.getLdapName(principal);
        _logger.log(Level.FINE, "dn={0}", dn);
        String principalName = this.getPrincipalName(dn);
        _logger.log(Level.FINE, "Certificate realm is setting up security context for principal: {0}", principalName);
        Enumeration<String> defaultGroups = this.getGroupNames(principalName);
        Set<Principal> principalSet = subject.getPrincipals();
        while (defaultGroups.hasMoreElements()) {
            principalSet.add((Principal)new Group(defaultGroups.nextElement()));
        }
        Set<Group> groupsFromDN = this.getGroupNamesFromDN(dn);
        principalSet.addAll(groupsFromDN);
        _logger.log(Level.FINE, "principalSet: {0}", principalSet);
        if (!subject.getPrincipals().isEmpty()) {
            subject.getPublicCredentials().add(new DistinguishedPrincipalCredential(principal));
        }
        SecurityContext.setCurrent(new SecurityContext(principalName, subject));
        return principalName;
    }

    private void validateSubjectViaAPI(Subject subject, X500Principal principal) {
        X509Certificate certificate = this.getCertificateFromSubject(subject, principal);
        if (certificate == null) {
            _logger.warning(() -> String.format("No X509Certificate found(subject=%s, principal=%s)", subject, principal));
            return;
        }
        List<Object> validators = Collections.emptyList();
        try {
            validators = this.loadValidatorClasses();
        }
        catch (Throwable exc) {
            _logger.log(Level.WARNING, "Exception while loading certificate validation class", exc);
            this.clientCertificateValidatorMap.remove(Utility.getClassLoader());
        }
        validators.add(new ClientCertificateExpiryValidator(this.getProperty(VALIDATION_CHECK_PROP)));
        boolean failed = false;
        for (ClientCertificateValidator clientCertificateValidator : validators) {
            if (clientCertificateValidator.isValid(subject, principal, certificate)) continue;
            _logger.info(() -> String.format("Client Certificate validation failed for (subject=%s, principal=%s) by %s", subject, principal, validator.getClass().getName()));
            failed = true;
            break;
        }
        if (failed) {
            throw new LoginException("Certificate Validation Failed via API");
        }
    }

    private List<ClientCertificateValidator> loadValidatorClasses() {
        AtomicReference serviceLoader = new AtomicReference();
        this.clientCertificateValidatorMap.compute(Utility.getClassLoader(), (cl, weak) -> {
            serviceLoader.set(weak != null ? (ServiceLoader)weak.get() : null);
            if (serviceLoader.get() == null) {
                serviceLoader.set(ServiceLoader.load(ClientCertificateValidator.class));
                return new WeakReference<ServiceLoader>((ServiceLoader)serviceLoader.get());
            }
            return weak;
        });
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(((ServiceLoader)serviceLoader.get()).iterator(), 16), false).collect(Collectors.toList());
    }

    private X509Certificate getCertificateFromSubject(Subject subject, X500Principal principal) {
        X509Certificate result = null;
        Set<Object> publicCredentials = subject.getPublicCredentials();
        for (Object publicCredential : publicCredentials) {
            if (!(publicCredential instanceof List)) continue;
            List data = (List)publicCredential;
            for (Object item : data) {
                X509Certificate certificate;
                if (!(item instanceof X509Certificate) || !principal.equals((certificate = (X509Certificate)item).getIssuerX500Principal())) continue;
                result = (X509Certificate)item;
            }
        }
        return result;
    }

    private LdapName getLdapName(X500Principal principal) {
        try {
            return new LdapName(principal.getName("RFC2253", OID.getOIDMap()));
        }
        catch (InvalidNameException e) {
            throw new IllegalStateException("Exception extracting DN from principal:\n" + principal, e);
        }
    }

    private String getPrincipalName(LdapName distinguishedName) {
        if (Boolean.parseBoolean(this.getProperty(COMMON_NAME_AS_PRINCIPAL_NAME))) {
            return distinguishedName.getRdns().stream().filter(rdn -> rdn.getType().equalsIgnoreCase(OID.CN.getName())).findFirst().orElseThrow(() -> new IllegalStateException("common-name-as-principal-name set to true, but no CN present in " + distinguishedName)).getValue().toString();
        }
        return distinguishedName.toString();
    }

    private Set<Group> getGroupNamesFromDN(LdapName distinguishedName) {
        _logger.log(Level.FINE, "getGroupNamesFromDN(distinguishedName={0})", distinguishedName);
        String dnPartsForGroups = this.getProperty(DN_PARTS_USED_FOR_GROUPS);
        if (dnPartsForGroups == null) {
            return Collections.emptySet();
        }
        Set oidNames = OID.toOIDS(dnPartsForGroups.split(",")).stream().map(OID::getName).collect(Collectors.toSet());
        Function<Rdn, Group> rdnToGroup = rdn -> new Group(rdn.getValue().toString());
        return distinguishedName.getRdns().stream().filter(rdn -> oidNames.contains(rdn.getType())).map(rdnToGroup).collect(Collectors.toSet());
    }

    public static final class AppContextCallback
    implements Callback {
        private String moduleID;

        public String getModuleID() {
            return this.moduleID;
        }

        public void setModuleID(String moduleID) {
            this.moduleID = moduleID;
        }
    }
}

