/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.solaris;

import com.sun.enterprise.security.BaseRealm;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.jvnet.hk2.annotations.Service;

@Service
public final class SolarisRealm
extends BaseRealm {
    public static final String AUTH_TYPE = "solaris";
    private static final String OS_ARCH = "os.arch";
    private static final String SOL_SPARC_OS_ARCH = "sparc";
    private static final String SOL_X86_OS_ARCH = "x86";
    private HashMap<String, Vector<String>> groupCache;
    private Vector<String> emptyVector;
    private static String osArchType = null;

    @Override
    protected synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String jaasCtx = props.getProperty("jaas-context");
        if (jaasCtx == null) {
            _logger.warning("realmconfig.noctx");
            throw new BadRealmException(sm.getString("solarisrealm.nojaas"));
        }
        this.setProperty("jaas-context", jaasCtx);
        _logger.fine(() -> "SolarisRealm : jaas-context=" + jaasCtx);
        this.groupCache = new HashMap();
        this.emptyVector = new Vector();
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    @Override
    public Enumeration<String> getGroupNames(String username) throws InvalidOperationException, NoSuchUserException {
        Vector<String> v = this.groupCache.get(username);
        if (v == null) {
            v = this.loadGroupNames(username);
        }
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGroupNames(String username, String[] groups) {
        Vector<String> v = null;
        if (groups == null) {
            v = this.emptyVector;
        } else {
            v = new Vector(groups.length);
            for (String group : groups) {
                v.add(group);
            }
        }
        String[] stringArray = this;
        synchronized (this) {
            this.groupCache.put(username, v);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public String[] authenticate(String username, char[] password) {
        String[] grps = SolarisRealm.nativeAuthenticate(username, new String(password));
        if (grps != null) {
            grps = this.addAssignGroups(grps);
        }
        this.setGroupNames(username, grps);
        return grps;
    }

    private Vector<String> loadGroupNames(String username) {
        String[] grps = SolarisRealm.nativeGetGroups(username);
        if (grps == null) {
            _logger.fine("No groups returned for user: " + username);
        }
        grps = this.addAssignGroups(grps);
        this.setGroupNames(username, grps);
        return this.groupCache.get(username);
    }

    private static native String[] nativeAuthenticate(String var0, String var1);

    private static native String[] nativeGetGroups(String var0);

    static {
        osArchType = System.getProperty(OS_ARCH);
        if (SOL_SPARC_OS_ARCH.equals(osArchType)) {
            System.loadLibrary("solsparcauth");
        } else if (SOL_X86_OS_ARCH.equals(osArchType)) {
            System.loadLibrary("solx86auth");
        }
    }
}

