/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.Iterator;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-password-aliases")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.password.alias")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-password-aliases", description="list-password-aliases")})
@AccessRequired(resource={"domain/passwordAliases"}, action={"read"})
public class ListPasswordAlias
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListPasswordAlias.class);
    @Inject
    private DomainScopedPasswordAliasStore domainPasswordAliasStore;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Iterator it = this.domainPasswordAliasStore.keys();
            if (!it.hasNext()) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                report.setMessage(localStrings.getLocalString("list.password.alias.nothingtolist", "Nothing to list"));
            }
            while (it.hasNext()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage((String)it.next());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            report.setMessage(localStrings.getLocalString("list.password.alias.fail", "Listing of Password Alias failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
        }
    }
}

