/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.embedded;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.EmbeddedSecurity;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class EmbeddedSecurityUtil
implements EmbeddedSecurity {
    private static final Logger LOGGER = SecurityLoggerInfo.getLogger();

    @Override
    public void copyConfigFiles(ServiceLocator habitat, File fromInstanceDir, File domainXml) {
        ServerEnvironment se = (ServerEnvironment)habitat.getService(ServerEnvironment.class, new Annotation[0]);
        if (!this.isEmbedded(se)) {
            return;
        }
        if (fromInstanceDir == null || domainXml == null) {
            throw new IllegalArgumentException("Null inputs");
        }
        File toInstanceDir = ((ServerEnvironmentImpl)habitat.getService(ServerEnvironmentImpl.class, new Annotation[0])).getInstanceRoot();
        ArrayList<Object> fileNames = new ArrayList<Object>();
        try {
            fileNames.addAll(new EmbeddedSecurityUtil().new DomainXmlSecurityParser(domainXml).getAbsolutePathKeyFileNames(fromInstanceDir));
            String keyStoreFileName = fromInstanceDir + File.separator + "config" + File.separator + "keystore.p12";
            String trustStoreFileName = fromInstanceDir + File.separator + "config" + File.separator + "cacerts.p12";
            fileNames.add(keyStoreFileName);
            fileNames.add(trustStoreFileName);
            String loginConf = fromInstanceDir + File.separator + "config" + File.separator + "login.conf";
            String secPolicy = fromInstanceDir + File.separator + "config" + File.separator + "server.policy";
            fileNames.add(loginConf);
            fileNames.add(secPolicy);
            File toConfigDir = new File(toInstanceDir, "config");
            if (!toConfigDir.exists() && !toConfigDir.mkdir()) {
                throw new IOException();
            }
            for (String string : fileNames) {
                FileUtils.copyFile((File)new File(string), (File)new File(toConfigDir, this.parseFileName(string)));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "NCLS-SECURITY-01004", e);
        }
        catch (XMLStreamException e) {
            LOGGER.log(Level.WARNING, "NCLS-SECURITY-01005", e);
        }
    }

    @Override
    public String parseFileName(String fullFilePath) {
        if (fullFilePath == null) {
            return null;
        }
        File file = new File(fullFilePath);
        return file.getName();
    }

    @Override
    public boolean isEmbedded(ServerEnvironment se) {
        return se.getRuntimeType() == RuntimeType.EMBEDDED;
    }

    @Override
    public List<String> getKeyFileNames(SecurityService securityService) {
        ArrayList<String> keyFileNames = new ArrayList<String>();
        List authRealms = securityService.getAuthRealm();
        for (AuthRealm authRealm : authRealms) {
            String className = authRealm.getClassname();
            if (!"com.sun.enterprise.security.auth.realm.file.FileRealm".equals(className)) continue;
            List props = authRealm.getProperty();
            for (Property prop : props) {
                if (!"file".equals(prop.getName())) continue;
                keyFileNames.add(prop.getValue());
            }
        }
        return keyFileNames;
    }

    class DomainXmlSecurityParser {
        XMLStreamReader xmlReader;
        XMLInputFactory xif = XMLInputFactory.newInstance();
        private static final String AUTH_REALM = "auth-realm";
        private static final String CONFIG = "config";
        private static final String CLASSNAME = "classname";
        private static final String FILE_REALM_CLASS = "com.sun.enterprise.security.auth.realm.file.FileRealm";
        private static final String PROPERTY = "property";
        private static final String NAME = "name";
        private static final String VALUE = "value";
        private static final String FILE = "file";
        private static final String INSTANCE_DIR_PLACEHOLDER = "${com.sun.aas.instanceRoot}";

        DomainXmlSecurityParser(File domainXml) throws XMLStreamException, FileNotFoundException {
            this.xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            this.xif.setProperty("javax.xml.stream.isValidating", true);
            this.xmlReader = this.xif.createXMLStreamReader(new FileReader(domainXml));
        }

        private String replaceInstanceDir(String fromInstanceDir, String keyFileName) {
            return StringUtils.replace((String)keyFileName, (String)INSTANCE_DIR_PLACEHOLDER, (String)fromInstanceDir);
        }

        List<String> getAbsolutePathKeyFileNames(File fromInstanceDir) throws XMLStreamException {
            ArrayList<String> keyFileNames = new ArrayList<String>();
            while (this.skipToStartButNotPast(AUTH_REALM, CONFIG)) {
                String realmClass = this.xmlReader.getAttributeValue(null, CLASSNAME);
                if (!realmClass.equals(FILE_REALM_CLASS)) continue;
                while (this.skipToStartButNotPast(PROPERTY, AUTH_REALM)) {
                    if (!FILE.equals(this.xmlReader.getAttributeValue(null, NAME))) continue;
                    String keyFileName = this.xmlReader.getAttributeValue(null, VALUE);
                    keyFileNames.add(this.replaceInstanceDir(fromInstanceDir.getAbsolutePath(), keyFileName));
                }
            }
            return keyFileNames;
        }

        private boolean skipToStartButNotPast(String startName, String stopName) throws XMLStreamException {
            if (!StringUtils.ok((String)startName) || !StringUtils.ok((String)stopName)) {
                throw new IllegalArgumentException();
            }
            while (this.xmlReader.hasNext()) {
                this.xmlReader.next();
                if (this.xmlReader.isStartElement() && startName.equals(this.xmlReader.getLocalName())) {
                    return true;
                }
                if (!this.xmlReader.isEndElement() || !stopName.equals(this.xmlReader.getLocalName())) continue;
                return false;
            }
            return false;
        }
    }
}

