/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityManagerFactory {
    protected SecurityManagerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getManager(Map<String, Map<String, T>> iD2sMmap, String ctxId, String name, boolean remove) {
        T manager = null;
        Map<String, Map<String, T>> map = iD2sMmap;
        synchronized (map) {
            Map<String, T> managerMap = iD2sMmap.get(ctxId);
            if (managerMap != null) {
                manager = managerMap.get(name);
                if (remove) {
                    managerMap.remove(name);
                    if (managerMap.isEmpty()) {
                        iD2sMmap.remove(ctxId);
                    }
                }
            }
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ArrayList<T> getManagers(Map<String, Map<String, T>> iD2sMmap, String ctxId, boolean remove) {
        ArrayList<T> managers = null;
        Map<String, Map<String, T>> map = iD2sMmap;
        synchronized (map) {
            Map<String, T> managerMap = iD2sMmap.get(ctxId);
            if (managerMap != null && !managerMap.isEmpty()) {
                managers = new ArrayList<T>(managerMap.values());
            }
            if (remove) {
                iD2sMmap.remove(ctxId);
            }
        }
        return managers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getManagersForApp(Map<String, Map<String, T>> iD2sMmap, Map<String, List<String>> app2iDmap, String appName, boolean remove) {
        ArrayList<T> managerList = null;
        String[] ctxIds = this.getContextsForApp(app2iDmap, appName, remove);
        if (ctxIds != null) {
            ArrayList<T> managers = null;
            Map<String, Map<String, T>> map = iD2sMmap;
            synchronized (map) {
                for (String id : ctxIds) {
                    managers = this.getManagers(iD2sMmap, id, remove);
                    if (managers == null) continue;
                    if (managerList == null) {
                        managerList = new ArrayList<T>();
                    }
                    managerList.addAll(managers);
                }
            }
        }
        return managerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> String[] getContextsForApp(Map<String, List<String>> app2iDmap, String appName, boolean remove) {
        String[] ctxIds = null;
        Map<String, List<String>> map = app2iDmap;
        synchronized (map) {
            List<String> ctxList = app2iDmap.get(appName);
            if (ctxList != null && !ctxList.isEmpty()) {
                ctxIds = ctxList.toArray(new String[ctxList.size()]);
            }
            if (remove) {
                app2iDmap.remove(appName);
            }
        }
        return ctxIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addManagerToApp(Map<String, Map<String, T>> iD2sMmap, Map<String, List<String>> app2iDmap, String ctxId, String name, String appName, T manager) {
        Map<String, Object> map = iD2sMmap;
        synchronized (map) {
            Map<String, T> managerMap = iD2sMmap.get(ctxId);
            if (managerMap == null) {
                managerMap = new HashMap<String, T>();
                iD2sMmap.put(ctxId, managerMap);
            }
            managerMap.put(name, manager);
        }
        map = app2iDmap;
        synchronized (map) {
            List ctxList = app2iDmap.computeIfAbsent(appName, e -> new ArrayList());
            if (!ctxList.contains(ctxId)) {
                ctxList.add(ctxId);
            }
        }
    }
}

