/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.ssl.J2EEKeyManager;
import com.sun.enterprise.security.ssl.SSLUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;
import org.glassfish.grizzly.config.ssl.JSSE14SocketFactory;
import org.glassfish.internal.api.Globals;

public class GlassfishServerSocketFactory
extends JSSE14SocketFactory {
    private SSLUtils sslUtils;

    protected KeyManager[] getKeyManagers(String algorithm, String keyAlias) throws Exception {
        if (this.sslUtils == null) {
            this.initSSLUtils();
        }
        String keystoreFile = (String)this.attributes.get("keystore");
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Keystore file= {0}", keystoreFile);
        }
        String keystoreType = (String)this.attributes.get("keystoreType");
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Keystore type= {0}", keystoreType);
        }
        boolean aliasFound = false;
        for (KeyStore keyStore : this.sslUtils.getKeyStores()) {
            if (!keyStore.isKeyEntry(keyAlias)) continue;
            aliasFound = true;
            break;
        }
        if (!aliasFound) {
            logger.log(Level.WARNING, "Unable to find key pair alias {0} in any of the configured key stores, therefore the server may not be able to present a valid SSL Certificate", keyAlias);
        }
        KeyManager[] kMgrs = this.sslUtils.getKeyManagers(algorithm);
        if (keyAlias != null && keyAlias.length() > 0 && kMgrs != null) {
            for (int i = 0; i < kMgrs.length; ++i) {
                kMgrs[i] = new J2EEKeyManager((X509KeyManager)kMgrs[i], keyAlias);
            }
        }
        return kMgrs;
    }

    protected KeyStore[] getTrustStore() throws IOException {
        if (this.sslUtils == null) {
            this.initSSLUtils();
        }
        return this.sslUtils.getTrustStore();
    }

    private void initSSLUtils() {
        if (this.sslUtils == null) {
            if (Globals.getDefaultHabitat() != null) {
                this.sslUtils = (SSLUtils)Globals.getDefaultHabitat().getService(SSLUtils.class, new Annotation[0]);
            } else {
                this.sslUtils = new SSLUtils();
                this.sslUtils.postConstruct();
            }
        }
    }
}

