/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.rest.endpoints;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;

public class RestEndpointModel {
    private String path;
    private String requestMethod;

    private RestEndpointModel(String path, String requestMethod) {
        this.path = path;
        this.requestMethod = requestMethod;
    }

    public static RestEndpointModel generateFromMethod(Method method) {
        String requestMethod = RestEndpointModel.getRequestMethodAnnotation(method);
        if (requestMethod == null) {
            return null;
        }
        Class<?> enclosingClass = method.getDeclaringClass();
        String parentPath = RestEndpointModel.getPathAnnotation(enclosingClass);
        String childPath = RestEndpointModel.getPathAnnotation(method);
        Object path = parentPath + childPath;
        if (childPath.equals("/")) {
            path = parentPath;
        }
        return new RestEndpointModel((String)path, requestMethod);
    }

    private static String getPathAnnotation(AnnotatedElement element) {
        Path annotation = element.getAnnotation(Path.class);
        if (annotation == null || annotation.value().isEmpty()) {
            return "/";
        }
        return "/" + annotation.value().replaceAll("^/", "").replaceAll("/$", "");
    }

    private static String getRequestMethodAnnotation(AnnotatedElement element) {
        GET get = element.getAnnotation(GET.class);
        if (get != null) {
            return "GET";
        }
        POST post = element.getAnnotation(POST.class);
        if (post != null) {
            return "POST";
        }
        PUT put = element.getAnnotation(PUT.class);
        if (put != null) {
            return "PUT";
        }
        DELETE delete = element.getAnnotation(DELETE.class);
        if (delete != null) {
            return "DELETE";
        }
        HEAD head = element.getAnnotation(HEAD.class);
        if (head != null) {
            return "HEAD";
        }
        OPTIONS options = element.getAnnotation(OPTIONS.class);
        if (options != null) {
            return "OPTIONS";
        }
        PATCH patch = element.getAnnotation(PATCH.class);
        if (patch != null) {
            return "PATCH";
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }
}

