/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cdi.jsr107;

import com.hazelcast.core.HazelcastInstance;
import fish.payara.cdi.jsr107.impl.NamedCache;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.annotation.CacheDefaults;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;

public class JSR107Producer {
    private static final Logger logger = Logger.getLogger(JSR107Producer.class.getName());
    HazelcastCore hazelcastCore = HazelcastCore.getCore();

    @Dependent
    @Produces
    CachingProvider getCachingProvider() {
        if (!this.hazelcastCore.isEnabled()) {
            logger.warning("Unable to inject CachingProvider as Hazelcast is Disabled");
            return null;
        }
        return this.hazelcastCore.getCachingProvider();
    }

    @Dependent
    @Produces
    CacheManager getCacheManager(InjectionPoint point) {
        if (!this.hazelcastCore.isEnabled()) {
            logger.warning("Unable to inject CacheManager as Hazelcast is Disabled");
            return null;
        }
        return this.hazelcastCore.getCachingProvider().getCacheManager();
    }

    @Dependent
    @Produces
    HazelcastInstance getHazelcast() {
        if (!this.hazelcastCore.isEnabled()) {
            logger.warning("Unable to inject HazelcastInstance as Hazelcast is Disabled");
            return null;
        }
        return this.hazelcastCore.getInstance();
    }

    @Produces
    public <K, V> Cache<K, V> createCache(InjectionPoint ip) {
        Cache result;
        if (!this.hazelcastCore.isEnabled()) {
            logger.warning("Unable to inject Cache as Hazelcast is Disabled");
            return null;
        }
        String cacheName = ip.getMember().getDeclaringClass().getCanonicalName();
        NamedCache ncqualifier = (NamedCache)ip.getAnnotated().getAnnotation(NamedCache.class);
        CacheManager manager = this.getCacheManager(ip);
        if (ncqualifier != null) {
            Class valueClass;
            Class keyClass;
            String qualifierName = ncqualifier.cacheName();
            if (!"".equals(cacheName)) {
                cacheName = qualifierName;
            }
            if ((result = manager.getCache(cacheName, keyClass = ncqualifier.keyClass(), valueClass = ncqualifier.valueClass())) == null) {
                Class writerFactoryClass;
                MutableConfiguration config = new MutableConfiguration();
                config.setTypes(keyClass, valueClass);
                Class expiryPolicyFactoryClass = ncqualifier.expiryPolicyFactoryClass();
                if (!"Object".equals(expiryPolicyFactoryClass.getSimpleName())) {
                    Factory factory = FactoryBuilder.factoryOf((Class)expiryPolicyFactoryClass);
                    config.setExpiryPolicyFactory(factory);
                }
                if (!"Object".equals((writerFactoryClass = ncqualifier.cacheWriterFactoryClass()).getSimpleName())) {
                    Factory factory = FactoryBuilder.factoryOf((Class)writerFactoryClass);
                    config.setCacheWriterFactory(factory);
                }
                config.setWriteThrough(ncqualifier.writeThrough());
                Class loaderFactoryClass = ncqualifier.cacheLoaderFactoryClass();
                if (!"Object".equals(loaderFactoryClass.getSimpleName())) {
                    Factory factory = FactoryBuilder.factoryOf((Class)loaderFactoryClass);
                    config.setCacheLoaderFactory(factory);
                }
                config.setReadThrough(ncqualifier.readThrough());
                config.setManagementEnabled(ncqualifier.managementEnabled());
                config.setStatisticsEnabled(ncqualifier.statisticsEnabled());
                result = manager.createCache(cacheName, (Configuration)config);
            }
        } else {
            String cacheNameFromAnnotation;
            Class beanClass;
            CacheDefaults defaults;
            Bean bean = ip.getBean();
            if (bean != null && (defaults = (beanClass = bean.getBeanClass()).getAnnotation(CacheDefaults.class)) != null && !"".equals(cacheNameFromAnnotation = defaults.cacheName())) {
                cacheName = cacheNameFromAnnotation;
            }
            if ((result = manager.getCache(cacheName)) == null) {
                MutableConfiguration config = new MutableConfiguration();
                config.setManagementEnabled(true);
                config.setStatisticsEnabled(true);
                result = manager.createCache(cacheName, (Configuration)config);
            }
        }
        return result;
    }
}

