/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.impl.util.GlassFishObjectInputStream;
import com.sun.enterprise.container.common.impl.util.GlassFishObjectOutputStream;
import com.sun.enterprise.container.common.spi.util.GlassFishInputStreamHandler;
import com.sun.enterprise.container.common.spi.util.GlassFishOutputStreamHandler;
import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Service;

@Service
public class JavaEEIOUtilsImpl
implements JavaEEIOUtils {
    private static final Logger _logger = LogDomains.getLogger(JavaEEIOUtilsImpl.class, (String)"javax.enterprise.system.core.naming", (boolean)false);
    private final Collection<GlassFishOutputStreamHandler> outputHandlers = new CopyOnWriteArraySet<GlassFishOutputStreamHandler>();
    private final Collection<GlassFishInputStreamHandler> inputHandlers = new CopyOnWriteArraySet<GlassFishInputStreamHandler>();

    @Override
    public ObjectInputStream createObjectInputStream(InputStream is, boolean resolveObject, ClassLoader loader, long uniqueId) throws Exception {
        return new GlassFishObjectInputStream(this.inputHandlers, is, loader, resolveObject, uniqueId);
    }

    @Override
    public ObjectOutputStream createObjectOutputStream(OutputStream os, boolean replaceObject) throws IOException {
        return new GlassFishObjectOutputStream(this.outputHandlers, os, replaceObject);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serializeObject(Object obj, boolean replaceObject) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            block14: {
                ObjectOutputStream oos = this.createObjectOutputStream(bos, replaceObject);
                try {
                    oos.writeObject(obj);
                    oos.flush();
                    byArray = bos.toByteArray();
                    if (oos == null) break block14;
                }
                catch (Throwable throwable) {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                oos.close();
            }
            return byArray;
        }
        catch (NotSerializableException notSerEx) {
            throw notSerEx;
        }
        catch (Exception th) {
            throw new IOException(th);
        }
    }

    @Override
    public Object deserializeObject(byte[] data, boolean resolveObject, ClassLoader appClassLoader) throws Exception {
        return this.deserializeObject(data, resolveObject, appClassLoader, 0L);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deserializeObject(byte[] data, boolean resolveObject, ClassLoader appClassLoader, long uniqueId) throws Exception {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);){
            Object object;
            block13: {
                ObjectInputStream ois = this.createObjectInputStream(bis, resolveObject, appClassLoader, uniqueId);
                try {
                    object = ois.readObject();
                    if (ois == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ois.close();
            }
            return object;
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Error during deserialization", ex);
            throw ex;
        }
    }

    @Override
    public void addGlassFishOutputStreamHandler(GlassFishOutputStreamHandler handler) {
        this.outputHandlers.add(handler);
    }

    @Override
    public void removeGlassFishOutputStreamHandler(GlassFishOutputStreamHandler handler) {
        this.outputHandlers.remove(handler);
    }

    @Override
    public void addGlassFishInputStreamHandler(GlassFishInputStreamHandler handler) {
        this.inputHandlers.add(handler);
    }

    @Override
    public void removeGlassFishInputStreamHandler(GlassFishInputStreamHandler handler) {
        this.inputHandlers.remove(handler);
    }
}

