/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck.cdi.extension;

import fish.payara.microprofile.healthcheck.HealthCheckService;
import fish.payara.microprofile.healthcheck.HealthCheckType;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;

public class HealthCDIExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(HealthCDIExtension.class.getName());
    private final HealthCheckService healthService;
    private final String appName;
    private final Set<Bean<?>> healthCheckBeans;

    public HealthCDIExtension() {
        ServiceLocator serviceLocator = Globals.getDefaultBaseServiceLocator();
        InvocationManager invocationManager = (InvocationManager)serviceLocator.getService(InvocationManager.class, new Annotation[0]);
        this.appName = invocationManager.getCurrentInvocation().getAppName();
        this.healthService = (HealthCheckService)serviceLocator.getService(HealthCheckService.class, new Annotation[0]);
        this.healthCheckBeans = new HashSet();
    }

    void processBean(@Observes ProcessBean<?> event) {
        Bean bean = event.getBean();
        if (bean != null) {
            Set annotations = bean.getQualifiers();
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!Readiness.class.equals(annotationType) && !Liveness.class.equals(annotationType) && !Startup.class.equals(annotationType)) continue;
                this.healthCheckBeans.add(event.getBean());
            }
        }
    }

    void applicationInitialized(@Observes @Initialized(value=ApplicationScoped.class) Object init, BeanManager beanManager) {
        Iterator<Bean<?>> beanIterator = this.healthCheckBeans.iterator();
        while (beanIterator.hasNext()) {
            this.registerHealthCheck(beanIterator.next(), beanManager);
            beanIterator.remove();
        }
    }

    private void registerHealthCheck(Bean<?> bean, BeanManager beanManager) {
        HealthCheck healthCheck = (HealthCheck)beanManager.getReference(bean, HealthCheck.class, beanManager.createCreationalContext(bean));
        this.healthService.registerHealthCheck(this.appName, healthCheck, HealthCheckType.fromQualifiers(bean.getQualifiers()));
        this.healthService.registerClassLoader(this.appName, healthCheck.getClass().getClassLoader());
        LOGGER.log(Level.INFO, "Registered {0} as a HealthCheck for app: {1}", new Object[]{bean.getBeanClass().getCanonicalName(), this.appName});
    }
}

