/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.enterprise.transaction.spi.TransactionInternal;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.jta.TransactionState;
import com.sun.logging.LogDomains;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Unavailable;

public class TransactionImpl
implements TransactionInternal {
    private Control control;
    private GlobalTID gtid;
    private TransactionState tranState = null;
    private static TransactionManagerImpl tm = TransactionManagerImpl.getTransactionManagerImpl();
    static Logger _logger = LogDomains.getLogger(TransactionImpl.class, (String)"javax.enterprise.system.core.transaction");
    private long startTime;

    public TransactionImpl(Control control, GlobalTID gtid) throws SystemException {
        this.control = control;
        this.gtid = gtid;
        this.startTime = System.currentTimeMillis();
    }

    Control getControl() {
        return this.control;
    }

    public void commit() throws HeuristicMixedException, RollbackException, HeuristicRollbackException, IllegalStateException, SecurityException, SystemException {
        try {
            if (Configuration.isLocalFactory()) {
                ((ControlImpl)this.control).get_localTerminator().commit(true);
            } else {
                this.control.get_terminator().commit(true);
            }
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            RollbackException rbe = new RollbackException();
            Throwable cause = ex.getCause();
            if (cause != null) {
                rbe.initCause(cause);
            }
            throw rbe;
        }
        catch (INVALID_TRANSACTION ex) {
            throw new IllegalStateException();
        }
        catch (HeuristicMixed ex) {
            throw new HeuristicMixedException();
        }
        catch (HeuristicHazard ex) {
            throw new HeuristicMixedException();
        }
        catch (NO_PERMISSION ex) {
            throw new SecurityException();
        }
        catch (Unavailable ex) {
            SystemException sException = new SystemException();
            sException.initCause((Throwable)ex);
            throw sException;
        }
        catch (Exception ex) {
            SystemException sException = new SystemException();
            sException.initCause((Throwable)ex);
            throw sException;
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        try {
            if (Configuration.isLocalFactory()) {
                ((ControlImpl)this.control).get_localTerminator().rollback();
            } else {
                this.control.get_terminator().rollback();
            }
        }
        catch (INVALID_TRANSACTION ex) {
            throw new IllegalStateException();
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            throw new IllegalStateException();
        }
        catch (Unavailable ex) {
            SystemException sException = new SystemException();
            sException.initCause((Throwable)ex);
            throw sException;
        }
        catch (Exception ex) {
            SystemException sException = new SystemException();
            sException.initCause((Throwable)ex);
            throw sException;
        }
    }

    public boolean enlistResource(XAResource res) throws RollbackException, IllegalStateException, SystemException {
        int status = this.getStatus();
        if (status != 0 && status != 1) {
            throw new IllegalStateException();
        }
        try {
            if (tm.getXAResourceTimeOut() > 0) {
                res.setTransactionTimeout(tm.getXAResourceTimeOut());
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "jts.error_while_setting_xares_txn_timeout", ex);
        }
        try {
            if (this.tranState == null) {
                this.tranState = new TransactionState(this.gtid, this);
            }
            this.tranState.startAssociation(res, this.control, status);
            if (status == 1) {
                throw new RollbackException();
            }
            return true;
        }
        catch (XAException ex) {
            _logger.log(Level.WARNING, "jts.resource_outside_transaction", ex);
            if (ex.errorCode == -9) {
                throw new IllegalStateException();
            }
            throw new SystemException();
        }
    }

    public boolean delistResource(XAResource res, int flags) throws IllegalStateException, SystemException {
        try {
            if (this.tranState == null) {
                throw new IllegalStateException();
            }
            if (!this.tranState.containsXAResource(res)) {
                throw new IllegalStateException();
            }
            this.tranState.endAssociation(res, flags);
            if ((flags & 0x20000000) != 0) {
                this.setRollbackOnly();
            }
            return true;
        }
        catch (XAException ex) {
            this.setRollbackOnly();
            SystemException se = new SystemException();
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public int getStatus() throws SystemException {
        try {
            Status status = Configuration.isLocalFactory() ? ((ControlImpl)this.control).get_localCoordinator().get_status() : this.control.get_coordinator().get_status();
            return TransactionManagerImpl.mapStatus(status);
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            return 6;
        }
        catch (INVALID_TRANSACTION ex) {
            return 6;
        }
        catch (Unavailable ex) {
            return 6;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "jts.unexpected_error_in_getstatus", ex);
            throw new SystemException();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionImpl)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.gtid.equals(((TransactionImpl)object).gtid);
    }

    public int hashCode() {
        return this.gtid.hashCode();
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        int status = this.getStatus();
        if (status == 1) {
            throw new RollbackException();
        }
        if (status != 0) {
            throw new IllegalStateException();
        }
        if (this.tranState == null) {
            this.tranState = new TransactionState(this.gtid, this);
        }
        this.tranState.registerSynchronization(sync, this.control, false);
    }

    public void registerInterposedSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        int status = this.getStatus();
        if (status == 1) {
            throw new RollbackException();
        }
        if (status != 0) {
            throw new IllegalStateException();
        }
        if (this.tranState == null) {
            this.tranState = new TransactionState(this.gtid, this);
        }
        this.tranState.registerSynchronization(sync, this.control, true);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        int status = this.getStatus();
        if (status != 1 && status != 0) {
            throw new IllegalStateException();
        }
        try {
            if (Configuration.isLocalFactory()) {
                ((ControlImpl)this.control).get_localCoordinator().rollback_only();
            } else {
                this.control.get_coordinator().rollback_only();
            }
        }
        catch (Inactive ex) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(ex);
            throw ise;
        }
        catch (Exception ex) {
            SystemException se = new SystemException();
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public String getTransactionId() {
        return this.gtid.toString();
    }

    public long getStartTime() {
        return this.startTime;
    }
}

