/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.utils;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.Xid;

public class LogFormatter {
    public static String convertToString(byte[] byteArray) {
        StringBuilder strBuf = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            strBuf.append(byteArray[i]);
        }
        return strBuf.toString();
    }

    public static String convertXidArrayToString(Xid[] xidArray) {
        if (xidArray.length != 0) {
            StringBuilder strBuf = new StringBuilder("Xid class name is " + xidArray[0].getClass().getName() + " Number of Xids are " + xidArray.length + " [ ");
            for (int i = 0; i < xidArray.length - 1; ++i) {
                strBuf.append(xidArray[i]).append("\n");
            }
            strBuf.append(xidArray[xidArray.length - 1]).append(" ]");
            return strBuf.toString();
        }
        return " null ";
    }

    public static String convertPropsToString(Properties prop) {
        if (prop == null) {
            return "{null}";
        }
        StringBuilder strBuf = new StringBuilder("{ ");
        Enumeration<?> enum1 = prop.propertyNames();
        while (enum1.hasMoreElements()) {
            Object obj = enum1.nextElement();
            strBuf.append("[ ").append(obj).append("->");
            String val = prop.getProperty((String)obj);
            if (val == null) {
                strBuf.append("null");
            } else {
                strBuf.append(val);
            }
            strBuf.append(" ] ");
        }
        strBuf.append("}");
        return strBuf.toString();
    }

    public static String getLocalizedMessage(Logger logger, String key) {
        try {
            ResourceBundle rb = logger.getResourceBundle();
            String message = rb.getString(key);
            return message;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "JTS:Error while localizing the log message");
            return key;
        }
    }

    public static String getLocalizedMessage(Logger logger, String key, Object[] args) {
        try {
            ResourceBundle rb = logger.getResourceBundle();
            String message = rb.getString(key);
            return MessageFormat.format(message, args);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "JTS:Error while localizing the log message");
            return key;
        }
    }
}

