/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.valves.ValveBase;

public class SingleSignOn
extends ValveBase
implements SessionListener {
    protected static final String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected final ConcurrentMap<String, SingleSignOnEntry> cache = new ConcurrentHashMap<String, SingleSignOnEntry>();

    @Override
    public int getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        if (this.debug >= 1) {
            this.log(rb.getString("AS-WEB-CORE-00005"));
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log(rb.getString("AS-WEB-CORE-00006"));
        }
        super.stop();
    }

    @Override
    public void sessionEvent(SessionEvent event) {
        String ssoId;
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (this.debug >= 1) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00007"), session);
            this.log(msg);
        }
        if ((ssoId = session.getSsoId()) == null) {
            return;
        }
        this.deregister(ssoId, session);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        String msg;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        request.removeNote("org.apache.catalina.request.SSOVersion");
        if (this.debug >= 1) {
            msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00008"), hreq.getRequestURI());
            this.log(msg);
        }
        if (hreq.getUserPrincipal() != null) {
            if (this.debug >= 1) {
                msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00009"), hreq.getUserPrincipal());
                this.log(msg);
            }
            return 2;
        }
        if (this.debug >= 1) {
            this.log(rb.getString("AS-WEB-CORE-00010"));
        }
        Cookie cookie = null;
        Cookie versionCookie = null;
        Cookie[] cookies = hreq.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (Cookie cookie1 : cookies) {
            if ("JSESSIONIDSSO".equals(cookie1.getName())) {
                cookie = cookie1;
            } else if ("JSESSIONIDSSOVERSION".equals(cookie1.getName())) {
                versionCookie = cookie1;
            }
            if (cookie != null && versionCookie != null) break;
        }
        if (cookie == null) {
            if (this.debug >= 1) {
                this.log(rb.getString("AS-WEB-CORE-00011"));
            }
            return 1;
        }
        if (this.debug >= 1) {
            String msg2 = MessageFormat.format(rb.getString("AS-WEB-CORE-00012"), cookie.getValue());
            this.log(msg2);
        }
        long version = 0L;
        if (this.isVersioningSupported() && versionCookie != null) {
            version = Long.parseLong(versionCookie.getValue());
        }
        if ((entry = this.lookup(cookie.getValue(), version)) != null) {
            if (this.debug >= 1) {
                String msg3 = MessageFormat.format(rb.getString("AS-WEB-CORE-00013"), entry.getPrincipal().getName(), entry.getAuthType());
                this.log(msg3);
            }
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            if (this.isVersioningSupported()) {
                long ver = entry.incrementAndGetVersion();
                request.setNote("org.apache.catalina.request.SSOVersion", ver);
            }
            ((HttpRequest)request).setAuthType(entry.getAuthType());
            ((HttpRequest)request).setUserPrincipal(entry.getPrincipal());
        } else {
            if (this.debug >= 1) {
                this.log(rb.getString("AS-WEB-CORE-00014"));
            }
            cookie.setMaxAge(0);
            hres.addCookie(cookie);
        }
        return 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SingleSignOn[");
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    public void associate(String ssoId, long ssoVersion, Session session) {
        SingleSignOnEntry sso;
        if (!this.started) {
            return;
        }
        if (this.debug >= 1) {
            this.log(rb.getString("AS-WEB-CORE-00015"));
        }
        if ((sso = this.lookup(ssoId, ssoVersion)) != null) {
            session.setSsoId(ssoId);
            session.setSsoVersion(ssoVersion);
            sso.addSession(this, session);
        }
    }

    protected void deregister(String ssoId, Session session) {
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso == null) {
            return;
        }
        session.setSsoId(null);
        session.setSsoVersion(0L);
        sso.removeSession(session);
        if (sso.isEmpty()) {
            this.cache.remove(ssoId);
        }
    }

    protected void register(String ssoId, Principal principal, String authType, String username, char[] password, String realmName) {
        if (this.debug >= 1) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00016"), ssoId, principal.getName(), authType);
            this.log(msg);
        }
        this.cache.put(ssoId, new SingleSignOnEntry(ssoId, 0L, principal, authType, username, realmName));
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable t) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, t, 2);
        } else {
            log.log(Level.WARNING, this.toString() + ": " + message, t);
        }
    }

    protected SingleSignOnEntry lookup(String ssoId) {
        return (SingleSignOnEntry)this.cache.get(ssoId);
    }

    protected SingleSignOnEntry lookup(String ssoId, long ssoVersion) {
        return this.lookup(ssoId);
    }

    public boolean isVersioningSupported() {
        return false;
    }
}

