/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.logger;

import jakarta.servlet.ServletException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.LifecycleSupport;

public class LoggerBase
implements Lifecycle,
Logger {
    protected static final java.util.logging.Logger log = LogFacade.getLogger();
    protected static final ResourceBundle rb = log.getResourceBundle();
    protected Container container = null;
    protected int debug = 0;
    protected static final String info = "org.apache.catalina.logger.LoggerBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected int verbosity = 1;
    protected ObjectName oname;
    protected ObjectName controller;

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int getVerbosity() {
        return this.verbosity;
    }

    @Override
    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public void setVerbosityLevel(String verbosity) {
        if ("FATAL".equalsIgnoreCase(verbosity)) {
            this.verbosity = Integer.MIN_VALUE;
        } else if ("ERROR".equalsIgnoreCase(verbosity)) {
            this.verbosity = 1;
        } else if ("WARNING".equalsIgnoreCase(verbosity)) {
            this.verbosity = 2;
        } else if ("INFORMATION".equalsIgnoreCase(verbosity)) {
            this.verbosity = 3;
        } else if ("DEBUG".equalsIgnoreCase(verbosity)) {
            this.verbosity = 4;
        }
    }

    public void setLevel(String logLevel) {
        if ("SEVERE".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.SEVERE);
        } else if ("WARNING".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.WARNING);
        } else if ("INFO".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.INFO);
        } else if ("CONFIG".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.CONFIG);
        } else if ("FINE".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.FINE);
        } else if ("FINER".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.FINER);
        } else if ("FINEST".equalsIgnoreCase(logLevel)) {
            log.setLevel(Level.FINEST);
        } else {
            log.setLevel(Level.INFO);
        }
    }

    public void addHandler(Handler handler) {
        log.setUseParentHandlers(false);
        handler.setLevel(log.getLevel());
        log.addHandler(handler);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void log(String msg) {
        log.log(Level.FINE, msg);
    }

    @Override
    public void log(Exception exception, String msg) {
        this.log(msg, exception);
    }

    @Override
    public void log(String msg, Throwable throwable) {
        CharArrayWriter buf = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buf);
        writer.println(msg);
        throwable.printStackTrace(writer);
        Throwable rootCause = null;
        if (throwable instanceof LifecycleException) {
            rootCause = ((LifecycleException)throwable).getCause();
        } else if (throwable instanceof ServletException) {
            rootCause = ((ServletException)throwable).getRootCause();
        }
        if (rootCause != null) {
            writer.println("----- Root Cause -----");
            rootCause.printStackTrace(writer);
        }
        this.log(buf.toString());
    }

    @Override
    public void log(String message, int verbosity) {
        if (this.verbosity >= verbosity) {
            this.log(message);
        }
    }

    @Override
    public void log(String message, Throwable throwable, int verbosity) {
        if (this.verbosity >= verbosity) {
            this.log(message, throwable);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public void init() {
    }

    public void destroy() {
    }

    public ObjectName createObjectName() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "createObjectName with {0}", this.container);
        }
        try {
            StandardEngine engine = null;
            Object suffix = "";
            if (this.container instanceof StandardEngine) {
                engine = (StandardEngine)this.container;
            } else if (this.container instanceof StandardHost) {
                engine = (StandardEngine)this.container.getParent();
                suffix = ",host=" + this.container.getName();
            } else if (this.container instanceof StandardContext) {
                String path = ((StandardContext)this.container).getPath();
                if (path.equals("")) {
                    path = "/";
                }
                engine = (StandardEngine)this.container.getParent().getParent();
                suffix = ",path=" + path + ",host=" + this.container.getParent().getName();
            } else {
                log.log(Level.SEVERE, "AS-WEB-CORE-00302");
            }
            if (engine != null) {
                this.oname = new ObjectName(engine.getDomain() + ":type=Logger" + (String)suffix);
            } else {
                log.log(Level.SEVERE, "AS-WEB-CORE-00303", this.container);
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "AS-WEB-CORE-00304", e);
        }
        return this.oname;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.getObjectName() == null) {
            ObjectName oname = this.createObjectName();
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Registering logger {0}", oname);
                }
            }
            catch (Exception ex) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00305"), oname);
                log.log(Level.SEVERE, msg, ex);
            }
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (this.getObjectName() != null) {
            ObjectName oname = this.createObjectName();
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Unregistering logger {0}", oname);
                }
            }
            catch (Exception ex) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00305"), oname);
                log.log(Level.SEVERE, msg, ex);
            }
        }
    }
}

