/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.startup.UserConfig;
import org.apache.catalina.startup.UserDatabase;

public final class PasswdUserDatabase
implements UserDatabase {
    private static final Logger LOGGER = Logger.getLogger(PasswdUserDatabase.class.getName());
    private static final String PASSWORD_FILE = "/etc/passwd";
    private final Hashtable<String, String> homes = new Hashtable();
    private UserConfig userConfig = null;

    @Override
    public UserConfig getUserConfig() {
        return this.userConfig;
    }

    @Override
    public void setUserConfig(UserConfig userConfig) {
        this.userConfig = userConfig;
        this.init();
    }

    @Override
    public String getHome(String user) {
        return this.homes.get(user);
    }

    @Override
    public Enumeration<String> getUsers() {
        return this.homes.keys();
    }

    private void init() {
        try (BufferedReader reader = new BufferedReader(new FileReader(PASSWORD_FILE));){
            while (true) {
                int ch;
                StringBuilder buffer = new StringBuilder();
                while ((ch = reader.read()) >= 0 && ch != 10) {
                    buffer.append((char)ch);
                }
                String line = buffer.toString();
                if (line.length() < 1) {
                    break;
                }
                int n = 0;
                String[] tokens = new String[7];
                for (int i = 0; i < tokens.length; ++i) {
                    tokens[i] = null;
                }
                while (n < tokens.length) {
                    String token;
                    int colon = line.indexOf(58);
                    if (colon >= 0) {
                        token = line.substring(0, colon);
                        line = line.substring(colon + 1);
                    } else {
                        token = line;
                        line = "";
                    }
                    tokens[n++] = token;
                }
                if (tokens[0] == null || tokens[5] == null) continue;
                this.homes.put(tokens[0], tokens[5]);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Initialization of set of users and home directories failed.", e);
        }
    }
}

