/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.server.logging.LogFacade;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExcludeFieldsSupport {
    private static final Logger LOG = LogFacade.LOGGING_LOGGER;
    private final BitSet excludeSuppAttrsBits = new BitSet();

    public ExcludeFieldsSupport(String excludeFields) {
        this.setExcludeFields(excludeFields);
    }

    private void setExcludeFields(String excludeFields) {
        this.excludeSuppAttrsBits.clear();
        if (excludeFields != null) {
            String[] fields;
            String[] stringArray = fields = excludeFields.split(",");
            int n = stringArray.length;
            block14: for (int i = 0; i < n; ++i) {
                String field;
                switch (field = stringArray[i]) {
                    case "": {
                        continue block14;
                    }
                    case "tid": {
                        this.excludeSuppAttrsBits.set(SupplementalAttribute.TID.ordinal());
                        continue block14;
                    }
                    case "timeMillis": {
                        this.excludeSuppAttrsBits.set(SupplementalAttribute.TIME_MILLIS.ordinal());
                        continue block14;
                    }
                    case "levelValue": {
                        this.excludeSuppAttrsBits.set(SupplementalAttribute.LEVEL_VALUE.ordinal());
                        continue block14;
                    }
                    case "version": {
                        this.excludeSuppAttrsBits.set(SupplementalAttribute.VERSION.ordinal());
                        continue block14;
                    }
                    default: {
                        LOG.log(Level.WARNING, String.format("Unknown Exclude Field provided : '%s'", field));
                    }
                }
            }
        }
    }

    public boolean isSet(SupplementalAttribute attr) {
        return this.excludeSuppAttrsBits.get(attr.ordinal());
    }

    public static enum SupplementalAttribute {
        TID,
        TIME_MILLIS,
        LEVEL_VALUE,
        VERSION;

    }
}

